#!/bin/sh
#
# start.sh [analysis]
#
# Script to submit an analysis

# Shourov K. Chatterji
# shourov@ligo.caltech.edu

# Eric Chassande-Mottin
# adapt to qsub queues

# $Id: start.sh,v 1.2 2008/09/10 15:09:28 ecm Exp $

# parse command line arguments
if [ $# -ge 1 ]; then
  analysisNumber=`printf "%02d" $1`
fi

# check if status table is empty
if [ ! -s status ]; then
    echo "status table is empty"
    exit 0
fi

# determine analysis number from status table
if [ -z $analysisNumber ]; then
    analysisNumber=`grep -v "submitted" status | sort | head -1 | awk '{print $1}'`    
fi

# get the remaining analyses with this analysis number
remainingAnalysis=`grep -n "^${analysisNumber}" status | grep -v "submitted" | sort | head -1`

if [ -z "${remainingAnalysis}" ]; then
    echo "all analyses have been started"
    exit 0
fi

# name of submission file
submissionFiles=`/bin/ls -1 *.batch 2>/dev/null | sed -e 's|^.*/||'`

# test for submission file
if [ -z "${submissionFiles}" ]; then
  echo "ERROR: submission files not found" 1>&2
  exit 1
fi

# check if required analysis number is available
submissionFile=`echo "${submissionFiles}" | grep ${analysisNumber}`

if [ -z "${submissionFile}" ]; then
    printf "ERROR: submission file not found\n"
    exit 2
fi

if [ ! -x "${submissionFile}" ]; then
    printf "ERROR: %s not found\n" ${submissionFile}
    exit 2
fi

# get the line number of this analysis
lineNumber=$(echo $remainingAnalysis | cut -d: -f1)

# determine the run number
runNumber=`echo $remainingAnalysis | awk '{print $3}'`
runNumberNotInStatus=

# if the run number is not specified in status table, determine
# from the previous completed analysis with the same number
if [ -z $runNumber ]; then
    runNumberNotInStatus=0

    # get the complete analyses with this analysis number
    completeAnalysis=`grep "^${analysisNumber}" status | grep "submitted" | sort | tail -1`
    if [ -z "$completeAnalysis" ]; then
	runNumber=0
    else
	lastRunNumber=`echo $completeAnalysis | awk '{print $2}'`
	runNumber=$((lastRunNumber+1))
    fi	

fi


# check if qsub is in the path
if [ -x qsub ]; then
    echo "ERROR: qsub not found"
    exit 2
fi

# submit the analysis
printf "Starting submission using %s\n"  ${submissionFile}
error=0
export runNumber
while read jobDescription
do
    command="qsub -v runNumber ${jobDescription}"
    echo $command
    $command
    if  [ $? != "0" ]; then
	error=$?
    fi
done < ${submissionFile}

# create local log file structure
if [ ! -d ${runNumber}/log/stdout ]; then
    mkdir -p ${runNumber}/log/stdout
fi

if [ ! -d ${runNumber}/log/stderr ]; then
    mkdir -p ${runNumber}/log/stderr
fi

if [ ! -d ${runNumber}/results ]; then
    mkdir -p ${runNumber}/results
fi

# update status table
if [ ${runNumberNotInStatus} ]; then
    sed -e "${lineNumber}s/$/ ${runNumber}/" < status > tmp_status
    mv -f tmp_status status
fi

sed -e "${lineNumber}s/$/ submitted/" < status > tmp_status
mv -f tmp_status status

# return exit status
exit $error
