/* jeffgraphics Copyright (c) 2010 Jeffrin Jose

 arc.c - Drawing Arc with cairo

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Jeffrin Jose) by sending a mail
     to jeffrin@rocketmail.com
*/
#include <gtk/gtk.h>
#include <cairo.h>
#include <math.h>

#define DEFAULT_WIDTH  400
#define DEFAULT_HEIGHT 300

/* forward definition of actual painting function for our drawing area widget
 */
static void paint (GtkWidget      *widget,
		   GdkEventExpose *eev,
                   gpointer        data);

gint
main (gint    argc,
      gchar **argv)
{
  GtkWidget *window;
  GtkWidget *canvas;

  gtk_init (&argc, &argv);

  /* create a new top level window
   */
  window   = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  /* make the gtk terminate the process the close button is pressed
   */
  g_signal_connect (G_OBJECT (window), "delete-event",
                    G_CALLBACK (gtk_main_quit), NULL);

  /* create a new drawing area widget
   */
  canvas = gtk_drawing_area_new ();

  /* set a requested (minimum size) for the canvas
   */
  gtk_widget_set_size_request (canvas, DEFAULT_WIDTH, DEFAULT_HEIGHT);

  /* connect our drawing method to the "expose" signal
   */
  g_signal_connect (G_OBJECT (canvas), "expose-event",
                    G_CALLBACK (paint),
                    NULL  /*< here we can pass a pointer to a custom data structure */
                  );

  /* pack canvas widget into window
   */
  gtk_container_add (GTK_CONTAINER (window), canvas);

  /* show window and all it's children (just the canvas widget)
   */
  gtk_widget_show_all (window);
 
  /* enter main loop
   */ 
  gtk_main ();
  return 0;
}


/* the actual function invoked to paint the canvas
 * widget, this is where most cairo painting functions
 * will go
 */
static void
paint (GtkWidget      *widget,
       GdkEventExpose *eev,
       gpointer        data)
{
  gint width, height;
  gint i;
  cairo_t *cr;

  width  = widget->allocation.width;
  height = widget->allocation.height;
  
  cr = gdk_cairo_create (widget->window);
  
    /* clear background */
    cairo_set_source_rgb (cr, 1,1,1);
    cairo_paint (cr);


    cairo_select_font_face (cr, "Sans", CAIRO_FONT_SLANT_NORMAL,
                                        CAIRO_FONT_WEIGHT_BOLD);

    /* enclosing in a save/restore pair since we alter the
     * font size
     */
    cairo_save (cr);
      cairo_set_source_rgb (cr, 0,0,0);

   //Vertical Line
            cairo_move_to(cr, 200,30);
            cairo_line_to(cr,200,200);

            //Horizontal Line
            cairo_move_to(cr, 50,120);
            cairo_line_to(cr,350,120);


            // Right Arc Of Lens.

            // cairo_arc(cr,200,115,85,-180*(M_PI/180),180*(M_PI/180));
            cairo_arc(cr,200,115,85,-90*(M_PI/180),90*(M_PI/180));

//    cairo_set_source_rgb (cr, 0,0,1);

    cairo_stroke (cr);

  cairo_destroy (cr);
}
