/* jeffgraphics Copyright (c) 2010 Jeffrin Jose

 geometry.c - Drawing Geometrical Figures with CAIRO

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Jeffrin Jose) by sending a mail
     to jeffrin@rocketmail.com
*/
#include <gtk/gtk.h>
#include <cairo.h>
#include <math.h>
#include <stdlib.h>

#define DEFAULT_WIDTH  400
#define DEFAULT_HEIGHT 300

//the global pixmap that will serve as our buffer
static GdkPixmap *pixmap = NULL;

/* forward definition of actual painting function for our drawing area widget
 */
static void rectangle (GtkWidget      *widget,
		   GdkEventExpose *eev,
                   gpointer        data);


gint
main (gint    argc,
      gchar **argv)
{
  GtkWidget *window;
  GtkWidget *canvas;
  gtk_init (&argc, &argv);

  /* create a new top level window
   */
  window   = gtk_window_new (GTK_WINDOW_TOPLEVEL);
//  gtk_window_set_resizable (GTK_WINDOW (window), FALSE);

  /* make the gtk terminate the process the close button is pressed
   */
  g_signal_connect (G_OBJECT (window), "delete-event",
                    G_CALLBACK (gtk_main_quit), NULL);

  /* create a new drawing area widget
   */
  canvas = gtk_drawing_area_new ();

  /* set a requested (minimum size) for the canvas
   */
  gtk_widget_set_size_request (canvas, DEFAULT_WIDTH, DEFAULT_HEIGHT);

  /* connect our drawing method to the "expose" signal
   */
  g_signal_connect (G_OBJECT (canvas), "expose-event",
                    G_CALLBACK (rectangle),
                    NULL  /*< here we can pass a pointer to a custom data structure */
                );
  /* pack canvas widget into window
   */
  gtk_container_add (GTK_CONTAINER (window), canvas);

  /* show window and all it's children (just the canvas widget)
   */
  gtk_widget_show_all (window);


  /* enter main loop
   */ 
  gtk_main ();
  return 0;
}


/* the actual function invoked to paint the canvas
 * widget, this is where most cairo painting functions
 * will go
 */
static void
rectangle (GtkWidget      *widget,
       GdkEventExpose *eev,
       gpointer        data)
{
  gint width, height;
  gint i,area,diagonal,selector;
gint pointx,pointy;
  cairo_t *cr;

//  gdk_threads_enter();
   // gdk_drawable_get_size(pixmap, &width, &height);
 //   gdk_threads_leave();

    //create a gtk-independant surface to draw on
  //  cairo_surface_t *cst = cairo_image_surface_create(CAIRO_FORMAT_ARGB32, width, height);
  //  cairo_t *cr = cairo_create(cst);



  width  = widget->allocation.width;
  height = widget->allocation.height;
  
  cr = gdk_cairo_create (widget->window);
  
    /* clear background */
    cairo_set_source_rgb (cr, 1,1,1);
    cairo_paint (cr);


    cairo_select_font_face (cr, "Sans", CAIRO_FONT_SLANT_NORMAL,
                                        CAIRO_FONT_WEIGHT_BOLD);

    /* enclosing in a save/restore pair since we alter the
     * font size
     */
    cairo_save (cr);
      cairo_set_source_rgb (cr, 0,0,0);
//for (i=0;i<3;i++) {
g_printf("Enter SELECTION :\n");
g_printf("Rectangle [0] :\n");
scanf("%d",&selector);
switch ( selector ) {
case 0:
   // Rectangle. 
            g_printf("----> coordinates for rectangle\n");
            scanf("%d %d",&pointx,&pointy);
            g_printf("width and height\n");
            scanf(" %d %d",&width,&height);
            area=width*height;
            diagonal= sqrt((pow(width,2)+ pow(height,2)));
       //     circumradius=diagonal/2;
            // cairo_arc(cr,200,115,85,-180*(M_PI/180),180*(M_PI/180));
            cairo_rectangle(cr,pointx,pointy,width,height);
            g_printf("Area of rectangle : %d\n",area);
            g_printf("Length of the diagonals :%d\n",diagonal);
            g_printf("Length of the Circumradius :%d\n",diagonal/2);
            g_printf("---->\n");
              
  break;
default:
g_printf("Good Bye \n"); 
  break;
}

//}
//    cairo_set_source_rgb (cr, 0,0,1);

    cairo_stroke (cr);

  cairo_destroy (cr);


}
