/*  BSD-License:

Copyright (c) 2010 by Matthias Bunte, Germany

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the authors the name nicai-systems nor
    the names of its contributors may be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*! @file    leds.h
 *  @brief   Controlling the LEDs
 *  @author  Matthias Bunte (m_bunte@arcor.de)
 *  @date    2010-04-06
 */

#ifndef _BEELIB_LEDS_H_
#define _BEELIB_LEDS_H_

#include <stdint.h>
#include "iodefs.h"

#ifdef __cplusplus
extern "C" {
#endif

#define LEDS_LED0   _BV(IO_LEDS_BIT_LED0)
#define LEDS_LED1   _BV(IO_LEDS_BIT_LED1)
#define LEDS_LED2   _BV(IO_LEDS_BIT_LED2)
#define LEDS_LED3   _BV(IO_LEDS_BIT_LED3)

#define LEDS_L_YE   _BV(IO_LEDS_BIT_L_YE)
#define LEDS_L_RD   _BV(IO_LEDS_BIT_L_RD)
#define LEDS_R_YE   _BV(IO_LEDS_BIT_R_YE)
#define LEDS_R_RD   _BV(IO_LEDS_BIT_R_RD)

#define LEDS_ALL    (LEDS_L_YE | LEDS_L_RD | LEDS_R_YE | LEDS_R_RD)

// Initialisierung der LEDs.
// Die Funktion muss vor Aufruf der anderen LED-Funktion aufgerufen werden um
// das Datenrichtungs-Register (DDRB) für die Ausgabe zu konfigurieren.
#define LEDS_INIT() do { \
  activate_output_group(IO_LEDS); \
} while (0)

// Einschalten der LEDs.
#define LEDS_ON(LEDBITS) do { \
  SET_FLAG(IO_LEDS_PORT, LEDBITS); \
} while (0)

// Ausschalten der LEDs.
#define LEDS_OFF(LEDBITS) do { \
  CLR_FLAG(IO_LEDS_PORT, LEDBITS); \
} while (0)

// Lesen der LED-Zustaende.
#define LEDS_GET(LEDBITS)  GET_FLAG(IO_LEDS_PORT, LEDBITS);

#ifdef __cplusplus
} // extern "C"
#endif

#endif // _BEELIB_LEDS_H_

