/*  BSD-License:

Copyright (c) 2007 by Nils Springob, nicai-systems, Germany
Copyright (c) 2010 by Matthias Bunte, Germany

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the authors the name nicai-systems nor
    the names of its contributors may be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*! @file    hal_odometers.h
 *  @brief   HAL for ATmega16: Sensing the ticks at the wheelsensors
 *  @author  Matthias Bunte (m_bunte@arcor.de)
 *  @date    2010-03-22
 */

#ifndef _BEELIB_HAL_ODOMETERS_H_
#define _BEELIB_HAL_ODOMETERS_H_

#include <avr/io.h>

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************/
/*  HAL - fuer Odometers-Einheit                                             */
/*****************************************************************************/

/*
 *  INT0: Fototransistor am linken Rad
 *  INT1: Fototransistor am rechten Rad
 *
 *  Beide sollen auf steigende Flanke den IRQ ausloesen / die ISR ausfuehren:
 *  Dazu im Register EICRA die Bits ICS00 - 11 setzen.
 */

/*
#define HAL_ODOMETERS_INIT() do { \
  SET_FLAG( MCUCR, (_BV(ISC11) | _BV(ISC10) | _BV(ISC01) | _BV(ISC00)) ); \
  SET_FLAG( GICR, (_BV(INT1) |  _BV(INT0)) ); \
} while(0)
*/

// Alternativ: Auf beide Flanken reagieren
#define HAL_ODOMETERS_INIT() do { \
  CLR_FLAG( MCUCR, (_BV(ISC11) | _BV(ISC01)) ); \
  SET_FLAG( MCUCR, (_BV(ISC10) | _BV(ISC00)) ); \
  SET_FLAG( GICR, (_BV(INT1) |  _BV(INT0)) ); \
} while(0)

/*****************************************************************************/
/*  End of HAL - fuer Odometers-Sensorik / Radsensor-Ticks                   */
/*****************************************************************************/


#ifdef __cplusplus
} // extern "C"
#endif


#endif // _BEELIB_HAL_ODOMETERS_H_

