/*  BSD-License:

Copyright (c) 2007 by Nils Springob, nicai-systems, Germany
Copyright (c) 2010 by Matthias Bunte, Germany

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the names of the authors the name nicai-systems nor
    the names of its contributors may be used to endorse or promote products
    derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

/*! @file    motorctrl.h
 *  @brief   Controlling the motor speed by pwm
 *  @author  Matthias Bunte (m_bunte@arcor.de)
 *  @date    2010-04-02
 */

#ifndef _BEELIB_MOTORCTRL_H_
#define _BEELIB_MOTORCTRL_H_

#include <stdint.h>
#include "hal_motorctrl.h"

#define MOTORCTRL_STOPP_VAL       (0)
#define MOTORCTRL_FULLSPEED_VAL   (MOTORCTRL_PWM_TIMER1_TOP)
#define MOTORCTRL_MINSPEED_VAL    (MOTORCTRL_FULLSPEED_VAL / 8)

#define MOTORCTRL_LEFT      (1)
#define MOTORCTRL_RIGHT     (0)
#define MOTORCTRL_FORWARD   (0)
#define MOTORCTRL_BACKWARD  (1)

#ifdef __cplusplus
extern "C" {
#endif

// Initialiserung für PWM.
void MotorCtrl_Init();

// Initialisierungszustand auslesen
uint8_t MotorCtrl_Initialized(void);

// Pruefe, ob schon initialisiert wurde und wenn nicht, initialisiere
#define MotorCtrl_CheckAndInit() do { \
  if (!MotorCtrl_Initialized()) MotorCtrl_Init(); \
} while (0)

// Lese PWM-Wert eines Motors
uint16_t MotorCtrl_GetSpeed(uint8_t IsLeft);

// PWM Signal ausschalten.
void MotorCtrl_Stopp();

// Neue Geschwindigkeit und Richtung fuer einen Motor vorgeben
void MotorCtrl_SetSpeedDir(uint8_t IsLeftMotor, uint16_t Speed, uint8_t IsBackward);


#ifdef __cplusplus
} // extern "C"
#endif


#endif // _BEELIB_MOTORCTRL_H_

