/* Copyright (C) 2012, 2013 Carlos Pais 
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "label.h"

#include <QDebug>

static LabelEditorWidget* mEditorWidget = 0;
ActionInfo Label::Info;

Label::Label(const QString& name, QObject *parent) :
    Action(parent)
{
    setObjectName(name);
    init();
}

Label::Label(const QVariantMap& data, QObject *parent) :
    Action(data, parent)
{
    init();
    setDisplayText(objectName());
}

void Label::init()
{
    setType(Info.type);
    setName(Info.name);
    setIcon(Info.icon);
}

void Label::setLabelEditorWidget(LabelEditorWidget * widget)
{
   mEditorWidget = widget;
}

LabelEditorWidget* Label::labelEditorWidget()
{
   return mEditorWidget;
}

ActionEditorWidget* Label::editorWidget()
{
    return mEditorWidget;
}

void Label::setObjectName(const QString & name)
{
    QObject::setObjectName(name);
    setDisplayText(name);
}
