/* Copyright (C) 2012, 2013 Carlos Pais 
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LABEL_H
#define LABEL_H

#include "action.h"
#include "label_editor_widget.h"

class LabelEditorWidget;

class Label : public Action
{
    Q_OBJECT

public:
    static ActionInfo Info;

public:
    explicit Label(const QString&, QObject *parent = 0);
    Label(const QVariantMap&, QObject *parent);
    static LabelEditorWidget* labelEditorWidget();
    static void setLabelEditorWidget(LabelEditorWidget*);
    virtual ActionEditorWidget* editorWidget();
    void setObjectName(const QString &);
    
signals:
    
public slots:

private:
    void init();
    
};

#endif // LABEL_H
