/* Copyright (C) 2012, 2013 Carlos Pais 
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "wait.h"

#include <QDebug>

static WaitEditorWidget *mEditorWidget = 0;
ActionInfo Wait::Info;

Wait::Wait(QObject *parent) :
    Action(parent)
{
    init();
}

Wait::Wait(const QVariantMap& data, QObject *parent) :
    Action(data, parent)
{
    init();

    if (data.contains("time") && data.value("time").canConvert(QVariant::Double))
        setTime(data.value("time").toDouble());

    if (data.contains("waitType") && data.value("waitType").type() == QVariant::String) {
        QString type = data.value("waitType").toString();

        if (type ==  "Timed")
            setWaitType(Wait::Timed);
        else if (type == "Forever")
            setWaitType(Wait::Forever);
        else
            setWaitType(Wait::MouseClick);
    }

    //setValue(waitTypeToString(mWaitType));
}

void Wait::init()
{
    setType(Info.type);
    setName(Info.name);
    setIcon(Info.icon);
    setWaitType(Timed);
    setTime(1);
}

void Wait::setWaitEditorWidget(WaitEditorWidget * widget)
{
   mEditorWidget = widget;
}

WaitEditorWidget* Wait::waitEditorWidget()
{
   return mEditorWidget;
}

ActionEditorWidget* Wait::editorWidget()
{
    return mEditorWidget;
}


void Wait::setTime(double t)
{
    mTime = t;
    if (mWaitType == Timed) {
        setDisplayText(QString::number(mTime) + tr(" second(s)"));
        emit dataChanged();
    }
}

double Wait::time()
{
    return mTime;
}

void Wait::setWaitType(WaitType type)
{
    mWaitType = type;
}

QString Wait::waitTypeToString(WaitType type)
{
    switch(type) {
    case Timed:
        return "Timed";
    case MouseClick:
        return "MouseClick";
    case Forever:
        return "Forever";
    }

    return "";
}

void Wait::setWaitTypeFromIndex(int index)
{
    switch (index) {
    case 0:
        mWaitType = Timed;
        break;
    case 1:
        mWaitType = MouseClick;
        break;
    case 2:
        mWaitType = Forever;
        break;
    }
}

Wait::WaitType Wait::waitType()
{
    return mWaitType;
}

QVariantMap Wait::toJsonObject()
{
    QVariantMap action = Action::toJsonObject();
    if (mWaitType == Wait::Timed)
        action.insert("time", mTime);
    action.insert("waitType", waitTypeToString(mWaitType));
    return action;
}
