/* Copyright (C) 2012, 2013 Carlos Pais 
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MENU_H
#define MENU_H

#include "objectgroup.h"

class Menu : public ObjectGroup
{
    Q_OBJECT

    int size;
    Object* mResourceButton;
    QStringList mConditions;

public:
    explicit Menu(QObject *parent = 0);
    Menu(const QVariantMap&, QObject* parent=0);

    QString optionText(int);
    void setOptionText(int, const QString&);
    QList<Action*> optionActions(int);
    void appendActionToOption(int, Action*);
    void removeActionFromOption(int, int, bool del=false);
    void setNumberOfOptions(int);
    void appendOption(const QString&);
    QString condition(int);
    void setCondition(int, const QString&);
    
signals:
    
public slots:

private:
    void init();
    
};

#endif // MENU_H
