#! /usr/bin/perl -w
#
# $Id: class-depend.pl,v 1.1.1.1 2003/09/25 18:13:51 evertonm Exp $

use strict;

{
    my $me = `basename $0`;
    chomp $me;
    
    sub say {
	foreach (@_) {
	    warn "$me: $_\n";
	}
    }

    sub debug {
	foreach (@_) {
	    warn "$me: DEBUG: $_\n";
	}
    }

    sub abort {
	&say(@_);
	exit(1);
    }
}

my @root_file_list;
my @path_list;

my %class_map = ( 
    path => {}, # fullPath               => { required => 1, done => 1 }
    full => {}, # package.name.className => { fullPath }
    base => {}, # className              => { package.name => fullPath }
    pack => {}  # package.name           => { className => fullPath }
    );

my $prefix;

foreach (@ARGV) {
    if (/prefix=(.+)/) {
	die "prefix redefinition: old=$prefix new=$1" if defined($prefix);
	$prefix = $1;
	next;
    }
    if (/classpath=(.+)/) {
	push(@path_list, split(/:/, $1));
	next;
    }
    push @root_file_list, $_;
}

&scan_class_tree(\%class_map, @path_list);

&solve(\%class_map, @root_file_list);

foreach my $path (keys %{$class_map{path}}) {
    if ($class_map{path}->{$path}->{required}) {
	if (defined($prefix)) {
	    print "$prefix/";
	}
	print "$path\n";
    }
}

exit;

#
#
#

sub scan_class_tree {
    my ($class_map_ref, @path_list) = @_;

    foreach (@path_list) {
	&scan_dir($class_map_ref, $_, '');
    }
}

sub scan_dir {
    my ($class_map_ref, $base, $dir) = @_;

    local *DIR;

    my $path = "$base/$dir";

    opendir(DIR, $path) || &abort("can't opendir $path: $!");

    foreach my $entry (readdir(DIR)) {
	my $entry_path = "$path/$entry";

	if (-f $entry_path) {

	    if ($entry =~ /(.+)\.java$/) {
		my $base_class_name = $1;

		my $full_class_name;

		my $pack_name;
		if (length $dir) {
		    $pack_name = $dir;
		    $pack_name =~ tr/\//./;
		    $full_class_name = "$pack_name.$base_class_name";
		}
		else {
		    $pack_name = '';
		    $full_class_name = $base_class_name;
		}

		if (exists($class_map_ref->{full}->{$full_class_name})) {
		    &abort("class redefinition: $full_class_name from $entry_path");
		}

		$class_map_ref->{base}->{$base_class_name}->{$pack_name} = $entry_path;
		$class_map_ref->{pack}->{$pack_name}->{$base_class_name} = $entry_path;
		#$class_map_ref->{path}->{$entry_path} = { done => 0, required => 0 };

		next;
	    }

	    next;
	}

	if (-d $entry_path) {
	    next if (($entry eq '.') || ($entry eq '..'));
	    my $sub_dir = (length $dir) ? "$dir/$entry" : $entry;
	    &scan_dir($class_map_ref, $base, $sub_dir);
	    next;
	}
    }

    closedir DIR;

#    foreach my $base (keys %{$class_map_ref->{base}}) {
#	for my $pack (keys %{$class_map_ref->{base}->{$base}}) {
#	    my $path = $class_map_ref->{base}->{$base}->{$pack};
#	    &debug("map: $base -> $pack -> $path");
#	}
#    }

#    foreach my $pack (keys %{$class_map_ref->{pack}}) {
#	for my $base (keys %{$class_map_ref->{pack}->{$pack}}) {
#	    my $path = $class_map_ref->{pack}->{$pack}->{$base};
#	    &debug("map: $pack -> $base -> $path");
#	}
#    }
}

sub solve {
    my ($class_map_ref, @file_list) = @_;

    foreach my $path (@file_list) {

	$class_map_ref->{path}->{$path}->{done} = 1;

	my $pack_name;
	my @pack_class_name_list;
	my @import_class_name_list;

	local *IN;
	open (IN, "<$path") || &abort("can't read file: $path: $!");
	while (<IN>) {
	    chomp;

	    my $line = $_;

	    if (/import\s+([^\s\;]+)\s*\;/) {
		my $import_name = $1;

		#&debug("$path: import $import_name");

		if ($import_name =~ /(.+)\.\*$/) {
		    my $pack_name = $1;
		    push (@import_class_name_list, keys %{$class_map_ref->{pack}->{$pack_name}});
		    next;
		}

		my $full_path = $class_map_ref->{full}->{$import_name};

		next unless defined($full_path);

		#&debug("$path DEPENDS-ON $full_path");

		$class_map_ref->{path}->{$full_path}->{required} = 1;

		next if ($class_map_ref->{path}->{$full_path}->{done});

		&solve($class_map_ref, $full_path);

		next;
	    }

	    if (/package\s+([^\s\;]+)\s*\;/) {

		#&debug("$path: package [$1]");

		die "package redefinition: $_" if defined($pack_name);
		$pack_name = $1;
		@pack_class_name_list = keys %{$class_map_ref->{pack}->{$pack_name}};

		next;
	    }

	    foreach my $class_name (@pack_class_name_list) {

		if ($line =~ /$class_name/) {

		    my $full_path = $class_map_ref->{base}->{$class_name}->{$pack_name};

		    #&debug("$path DEPENDS-ON $full_path");

		    $class_map_ref->{path}->{$full_path}->{required} = 1;

		    next if ($class_map_ref->{path}->{$full_path}->{done});

		    &solve($class_map_ref, $full_path);
		}
	    }

	    foreach my $class_name (@import_class_name_list) {

		if ($line =~ /$class_name/) {

		    my @pack_list = keys %{$class_map_ref->{base}->{$class_name}};

		    die "import conflict for class base=$class_name: $line" unless ($#pack_list == 0);

		    my ($pack_name) = @pack_list;

		    my $full_path = $class_map_ref->{base}->{$class_name}->{$pack_name};

		    #&debug("$path DEPENDS-ON $full_path");

		    $class_map_ref->{path}->{$full_path}->{required} = 1;

		    next if ($class_map_ref->{path}->{$full_path}->{done});

		    &solve($class_map_ref, $full_path);
		}
	    }
	}

	close IN;
    }
}
