#! /bin/sh

die () {
    echo $0: $* 1>&2
    exit 1
}

[ $# -eq 3 ] || {
    echo "usage: $0 gcj-cmd src-dir dst-dir" 1>&2
    exit 1
}

gcj_cmd=$1
src_dir=$2
dst_dir=$3

perform () {
    while read src; do
	obj=`echo $src | sed -e 's/\//_/g' -e 's/java$/o/'`
	cmd="$gcj_cmd -c $src -o $dst_dir/$obj"
	echo $cmd
	$cmd
    done
}

[ -d $dst_dir ] || die "dst dir not found: $dst_dir"

if [ $src_dir = '-' ]; then
    perform 
    exit
fi

[ -d $src_dir ] || die "src dir not found: $src_dir"

find $src_dir -name "*.java" | perform

