#! /bin/sh
#
# $Id: kickstart.sh,v 1.1 2003/11/18 23:11:06 evertonm Exp $

die () {
    echo $0: $* 1>&2
    exit 1
}

if [ $# -ne 4 ]; then
	cat 1>&2 <<EOF
usage: $0 bin_dir lib_dir cfg_dir log_dir
EOF
        exit 1
fi

BIN_DIR=$1
LIB_DIR=$2
CFG_DIR=$3
LOG_DIR=$4

[ -n "$BIN_DIR" ] || die "undefined BIN_DIR"
[ -n "$LIB_DIR" ] || die "undefined LIB_DIR"
[ -n "$CFG_DIR" ] || die "undefined CFG_DIR"
[ -n "$LOG_DIR" ] || die "undefined LOG_DIR"

[ -d "$BIN_DIR" ] || die "not a directory: BIN_DIR=$BIN_DIR"
[ -d "$LIB_DIR" ] || die "not a directory: LIB_DIR=$LIB_DIR"
[ -d "$CFG_DIR" ] || die "not a directory: CFG_DIR=$CFG_DIR"
[ -d "$LOG_DIR" ] || die "not a directory: LOG_DIR=$LOG_DIR"

LD_LIBRARY_PATH=$LIB_DIR $BIN_DIR/fea > $LOG_DIR/fea.log 2>&1 &
LD_LIBRARY_PATH=$LIB_DIR $BIN_DIR/rib > $LOG_DIR/rib.log 2>&1 &
LD_LIBRARY_PATH=$LIB_DIR $BIN_DIR/rip 1 > $LOG_DIR/rip.log 2>&1 &
LD_LIBRARY_PATH=$LIB_DIR $BIN_DIR/manager $CFG_DIR > $LOG_DIR/manager.log 2>&1 &

