/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: BeraConstants.java,v 1.2 2003/12/01 23:09:25 evertonm Exp $

package bera;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class BeraConstants {

    public static final String IPV4_WILDCARD_STRING = "0.0.0.0";
    public static final String EMPTY_STRING = "";
    public static final String SINGLE_BLANK_STRING = " ";
    public static final String RECEIVE_STRING = "(receive)";
    public static final String RIP_MULTICAST_ADDRESS = "224.0.0.9";
    public static final int RIP_UDP_PORT = 520;

    private static InetAddress RIP_MULTICAST_INET_ADDRESS;

    static {
	try {
	    RIP_MULTICAST_INET_ADDRESS = InetAddress.getByName(RIP_MULTICAST_ADDRESS);
	}
	catch (UnknownHostException e) {
	    System.err.println("ERROR: bera.BeraConstants: could not solve RIP multicast address '" + RIP_MULTICAST_ADDRESS + "': " + e);
	}
    }

    public static InetAddress getRipMulticastAddress() {
	return RIP_MULTICAST_INET_ADDRESS;
    }
}
