/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: FeaEngineDummy.java,v 1.5 2003/11/17 11:00:35 evertonm Exp $

package bera.fea;

import java.util.Vector;
import java.util.Hashtable;

import org.apache.log4j.Logger;

class FeaEngineDummy implements FeaEngineAdaptor {

    static private Logger logger = Logger.getLogger(FeaEngineDummy.class);

    private Vector dummyIfaceList;

    private static Vector hardCodedInterfaces() {
	Vector ifaceList = new Vector();

	Hashtable ifaceData;
	Vector    addrList;
	Hashtable addrData;

	// Interface 1

	ifaceData = new Hashtable();
	ifaceList.add(ifaceData);
	ifaceData.put("interfaceName", "BogusEthernet0");
	ifaceData.put("interfaceMetric", new Integer(1));
	ifaceData.put("interfaceCanMultiaccess", Boolean.valueOf(true));
	ifaceData.put("interfaceCanBroadcast", Boolean.valueOf(true));

	// Interface 1: Addr List 

	addrList = new Vector();
	ifaceData.put("interfaceInetAddresses", addrList);

	// Interface 1: Addr 1

	addrData = new Hashtable();
	addrList.add(addrData);
	addrData.put("addressFamily",       "IPv4");
	addrData.put("addressValue",        "192.168.0.1");
	addrData.put("addressPrefixLength", new Integer(24));

	// Interface 1: Addr 2

	addrData = new Hashtable();
	addrList.add(addrData);
	addrData.put("addressFamily",       "IPv4");
	addrData.put("addressValue",        "172.16.0.1");
	addrData.put("addressPrefixLength", new Integer(16));

	// Interface 2

	ifaceData = new Hashtable();
	ifaceList.add(ifaceData);
	ifaceData.put("interfaceName", "BogusSerial1");
	ifaceData.put("interfaceMetric", new Integer(5));
	ifaceData.put("interfaceCanMultiaccess", Boolean.valueOf(false));
	ifaceData.put("interfaceCanBroadcast", Boolean.valueOf(false));

	// Interface 2: Addr List

	addrList = new Vector();
	ifaceData.put("interfaceInetAddresses", addrList);

	// Interface 2: Addr 1

	addrData = new Hashtable();
	addrList.add(addrData);
	addrData.put("addressFamily",       "IPv4");
	addrData.put("addressValue",        "10.0.0.1");
	addrData.put("addressPrefixLength", new Integer(30));

	// Interface 3

	ifaceData = new Hashtable();
	ifaceList.add(ifaceData);
	ifaceData.put("interfaceName", "BogusATM2");
	ifaceData.put("interfaceMetric", new Integer(1));
	ifaceData.put("interfaceCanMultiaccess", Boolean.valueOf(true));
	ifaceData.put("interfaceCanBroadcast", Boolean.valueOf(false));

	// Interface 3: Addr List

	addrList = new Vector();
	ifaceData.put("interfaceInetAddresses", addrList);

	// Interface 3: Addr 1

	addrData = new Hashtable();
	addrList.add(addrData);
	addrData.put("addressFamily",       "IPv4");
	addrData.put("addressValue",        "10.1.0.1");
	addrData.put("addressPrefixLength", new Integer(8));

	return ifaceList;
    }

    FeaEngineDummy() {
	dummyIfaceList = hardCodedInterfaces();
    }

    public Vector getInterfaces() {
	return dummyIfaceList;
    }

    public Vector addRoutes(Vector routeList) {
	logger.debug("addRoutes()");
	return null;
    }

    public Vector withdrawRoutes(Vector routeList) {
	logger.debug("withdrawRoutes()");
	return null;
    }
}
