/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: Main.java,v 1.7 2003/11/15 00:06:05 evertonm Exp $

package bera.fea;

import org.apache.log4j.BasicConfigurator;
import org.apache.xmlrpc.WebServer;

import org.apache.log4j.Logger;

import bera.BeraServices;
import bera.BeraAssert;

public class Main {

    static private Logger logger = Logger.getLogger(Main.class);

    private static void serve(FeaEngineAdaptor engineAdaptor) { 

	logger.info("starting FEA xmlrpc server on port " + BeraServices.FEA_PORT);

	WebServer server = new WebServer(BeraServices.FEA_PORT);
	    
	server.addHandler("fea", new FeaRpcHandler(engineAdaptor));

	server.start();
    }

    private static FeaEngineAdaptor findEngineAdaptor() {

        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");

	logger.info("loading engine adaptor for plataform: " + osName + "/" + osVersion);

	if (osName.startsWith("Linux")) {
	    if (osVersion.startsWith("2.4.")) {
		logger.info("creating Linux iproute FEA engine adaptor");
		return new FeaEngineLinuxIPRoute();
	    }

	    logger.error("missing engine adaptor for Linux version: " + osVersion);
	}

	logger.info("unknown plataform: " + osName + "/" + osVersion);

	return null;
    }

    public static void main(String args[]) {
	BasicConfigurator.configure();

	FeaEngineAdaptor engineAdaptor = null;

	//
	// Simulation mode?
	//

	for (int i = 0; i < args.length; ++i) {
	    if (args[i].equals("-dummy")) {
		BeraAssert.require(engineAdaptor == null);
		logger.info("simulation: creating dummy FEA engine adaptor");
		engineAdaptor = new FeaEngineDummy();
		continue;
	    }

	    if (args[i].equals("-interactive")) {
		BeraAssert.require(engineAdaptor == null);
		logger.info("simulation: creating interactive FEA engine adaptor");
		FeaEngineInteractive interactive = new FeaEngineInteractive(System.in);
		interactive.start();
		engineAdaptor = interactive;
		continue;
	    }
	}

	//
	// Real mode?
	// 

	if (engineAdaptor == null) {
	    //
	    // Find the real FEA adaptor for this plataform
	    //
	    engineAdaptor = findEngineAdaptor();
	    if (engineAdaptor == null) {
		logger.error("could not find a suitable engine adaptor");
		System.exit(1);
	    }
	}

	serve(engineAdaptor);
    }
}

