/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: FileSaver.java,v 1.1 2003/11/10 01:35:49 evertonm Exp $

package bera.manager;

import java.io.File;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.IOException;

import org.apache.log4j.Logger;

class FileSaver implements LineSender {

    static private Logger logger = Logger.getLogger(FileSaver.class);

    private BufferedWriter writer;
    private boolean ioError = false;

    FileSaver(String path) throws IOException {
	File outputFile = new File(path);
	FileWriter fileWriter = new FileWriter(outputFile);
	writer = new BufferedWriter(fileWriter);
    }

    public void send(String line) {
	try {
	    writer.write(line, 0, line.length());
	}
	catch (IOException e) {
	    logger.error("failure writing to file: " + e);
	    ioError = true;
	}
    }

    public void sendLine(String line) {
	send(line);
	try {
	    writer.newLine();
	}
	catch (IOException e) {
	    logger.error("failure writing to file: " + e);
	    ioError = true;
	}
    }

    boolean error() {
	return ioError;
    }

    void close() {
	try {
	    writer.close();
	}
	catch (IOException e) {
	    logger.error("failure closing file: " + e);
	    ioError = true;
	}
	writer = null;
    }
}
