/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: Main.java,v 1.5 2003/11/10 01:35:49 evertonm Exp $

package bera.manager;

import java.io.IOException;
import java.io.File;

import org.apache.log4j.BasicConfigurator;
import org.apache.xmlrpc.WebServer;

import org.apache.log4j.Logger;

import bera.BeraServices;
import bera.telnet.TelnetServer;
import bera.telnet.TelnetHandler;

public class Main {

    static private Logger logger = Logger.getLogger(Main.class);

    private static void serve(String configDir) { 

	BeraManager manager = new BeraManager(configDir);

	//
	// Manager XMLRPC server
	//

        WebServer rpcServer = new WebServer(BeraServices.MANAGER_PORT);

        rpcServer.addHandler("manager", new ManagerRpcHandler(manager));

        logger.info("starting MANAGER xmlrpc server on port " + BeraServices.MANAGER_PORT);

        rpcServer.start();

	//
	// Manager TELNET server
	//

	TelnetHandler handler = new ManagerTelnetHandler(manager);

	final int telnetPort = 3000;

	TelnetServer telnetServer;
	try {
	    telnetServer = new TelnetServer(telnetPort, handler);
	}
	catch (IOException e) {
	    logger.error("could not create telnet server: " + e);
	    rpcServer.shutdown();
	    return;
	}

	logger.info("starting MANAGER telnet server on port " + telnetPort);

	telnetServer.start();
    }

    public static void main(String args[]) {

	BasicConfigurator.configure();

	String progName = "bera.manager.Main";

	if (args.length != 1) {
	    System.err.println("usage: " + progName + " configDirectory");
	    System.exit(1);
	}

	String configDir = args[0];

	File f = new File(configDir);
	if (!f.isDirectory()) {
	    System.err.println(progName + ": not a directory: " + configDir);
	    System.exit(1);
	}
	if (!f.canWrite()) {
	    System.err.println(progName + ": unable to write to directory: " + configDir);
	    System.exit(1);
	}

	serve(configDir);
    }
}

