/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: ManagerTelnetHandler.java,v 1.11 2003/11/15 00:06:05 evertonm Exp $

package bera.manager;

import java.net.Socket;
import java.util.Map;
import java.util.HashMap;
import java.io.IOException;

import org.apache.log4j.Logger;

import bera.grabline.LineReader;

import bera.BeraAssert;
import bera.telnet.TelnetHandler;
import bera.telnet.TelnetClient;
import bera.manager.command.CommandInterpreter;

class ManagerTelnetHandler implements TelnetHandler {

    static private Logger logger = Logger.getLogger(ManagerTelnetHandler.class);

    private BeraManager beraManager;
    private Map clientTable = new HashMap();

    ManagerTelnetHandler(BeraManager manager) {
	beraManager = manager;
    }

    public void input(TelnetClient client, String buf) {
	CommandInterpreter commandInterpreter = (CommandInterpreter) clientTable.get(client);
	commandInterpreter.execute(buf);
	client.flush();
    }

    public void remove(TelnetClient client) {
	clientTable.remove(client);
    }

    public LineReader add(TelnetClient client) {
	BeraAssert.require(client != null);
	BeraAssert.require(clientTable.get(client) == null);

	LineReader reader;
	//try {
	reader = new LineReader(client.getBufferedReader(), client.getBufferedWriter());
	//}
	//catch (IOException e) {
	//logger.error("could not create line reader: " + e);
	//return null;
	//}

	CommandInterpreter commandInterpreter = new CommandInterpreter(beraManager, client);
	clientTable.put(client, commandInterpreter);

	logger.debug("new client, total: " + clientTable.size());

	commandInterpreter.sendLine("");
	commandInterpreter.sendLine("bera manager");
	commandInterpreter.sendLine("");

	return reader;
    }

    public String getPrompt(TelnetClient client) {
	CommandInterpreter commandInterpreter = (CommandInterpreter) clientTable.get(client);
	return commandInterpreter.getPrompt();
    }
}

