/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: DoVersion.java,v 1.2 2003/11/15 00:06:06 evertonm Exp $

package bera.manager.command;

import bera.manager.command.CommandInterpreter;

class DoVersion extends Command {

    DoVersion(String label, String descr) {
	super(label, descr);
    }

    public boolean execute(CommandInterpreter interp, String cmdLine, String cmdArgs[]) {
	interp.send("BERA version:           ");
	interp.sendLine("0.1");
	interp.send("Host architecture:      "); 
	interp.sendLine(System.getProperty("os.arch"));
        interp.send("Host operating system:  "); 
	interp.sendLine(System.getProperty("os.name") + " " + System.getProperty("os.version"));
	interp.send("Host virtual machine:   ");
	interp.sendLine(System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
	interp.send("Virtual machine vendor: ");
	interp.sendLine(System.getProperty("java.vm.vendor"));
        interp.send("Operating system user:  ");
	interp.sendLine(System.getProperty("user.name"));

	return false;
    }
}

