/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: DoShow.java,v 1.4 2003/11/19 16:11:40 evertonm Exp $

package bera.manager.command.show;

import bera.manager.command.Command;
import bera.manager.command.CommandInterpreter;

public class DoShow extends Command {

    static final Show showTable[] = {
	new ShowFea("fea", "show fea information"),
	new ShowHelp("help", "list available show commands"),
	new ShowRip("rip", "show rip information")
    };

    static private Show findShow(String cmd) {
	for (int i = 0; i < showTable.length; ++i) 
	    if (showTable[i].matchPrefix(cmd))
		return showTable[i];
	return null;
    }

    private void executeShow(CommandInterpreter interp, String line, String args[]) {	
	Show show = findShow(args[1]);
	if (show == null) {
	    interp.sendLine("show command not found: " + line);
	    return;
	}

	show.execute(interp, this, line, args);
    }

    public DoShow(String label, String descr) {
	super(label, descr);
    }

    public boolean execute(CommandInterpreter interp, String cmdLine, String cmdArgs[]) {

	// Empty command?
	if (cmdArgs.length < 2) {
	    interp.sendLine("missing argument; try 'show help'");
	    return false;
	}

	executeShow(interp, cmdLine, cmdArgs);

	return false;
    }
}

