/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques
  Copyright (C) 2003  Fabricio Matheus Goncalves

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: ShowFea.java,v 1.2 2003/12/01 10:50:59 evertonm Exp $

package bera.manager.command.show;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import java.util.Iterator;

import org.apache.log4j.Logger;

import bera.net.BeraNetworkInterface;
import bera.net.BeraInterfaceAddress;
import bera.manager.command.CommandInterpreter;

class ShowFea extends Show {

    static private Logger logger = Logger.getLogger(ShowFea.class);

    ShowFea(String label, String descr) {
	super(label, descr);
    }

    static private void showFeaInterfaces(CommandInterpreter interp) {

	Vector currentInterfaceVector = BeraNetworkInterface.feaFetchInterfaces();
	List currentIfaceList = BeraNetworkInterface.makeInterfaceList(currentInterfaceVector);

	if (currentIfaceList == null) {
	    interp.sendLine("empty interface list");
	    return;
	}

	for (Iterator ifaceIt = currentIfaceList.iterator();
	     ifaceIt.hasNext();
	     ) {
	    BeraNetworkInterface iface = (BeraNetworkInterface) ifaceIt.next();

	    for (Iterator addrIt = iface.getAddresses().iterator();
		 addrIt.hasNext();
		 ) {
		BeraInterfaceAddress ifaceAddr = (BeraInterfaceAddress) addrIt.next();
	
		interp.send(iface.getName() + ": " + ifaceAddr.getAddress().getHostAddress() + "/" + ifaceAddr.getPrefixLength());
		if (iface.multiaccess())
		    interp.send(" multiaccess");

		if (iface.broadcast())
		    interp.send(" broadcast");

		interp.sendLine();
	    } // for

	} // for

    }

    void execute(CommandInterpreter interp, DoShow showCmd, String cmdLine, String cmdArgs[]) {
	logger.debug("FIXME: show fea interface");
	showFeaInterfaces(interp);
    }
}

