/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: ShowHelp.java,v 1.1 2003/11/13 01:34:18 evertonm Exp $

package bera.manager.command.show;

import bera.manager.command.CommandInterpreter;

class ShowHelp extends Show {

    ShowHelp(String label, String descr) {
	super(label, descr);
    }

    void execute(CommandInterpreter interp, DoShow showCmd, String cmdLine, String cmdArgs[]) {
	interp.sendLine("Available show commands:");
	for (int i = 0; i < showCmd.showTable.length; ++i) {
	    Show sh = showCmd.showTable[i];
	    interp.send(sh.getLabel());
	    int len = 10 - sh.getLabel().length();
	    for (int j = 0; j < len; ++j)
		interp.send(" ");
	    interp.sendLine(sh.getDescription());
	}
    }
}

