/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: ShowRip.java,v 1.3 2003/11/19 00:38:10 evertonm Exp $

package bera.manager.command.show;

import java.util.Vector;
import java.util.Hashtable;

import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

import bera.BeraServices;
import bera.BeraConstants;
import bera.manager.command.CommandInterpreter;

class ShowRip extends Show {

    static private Logger logger = Logger.getLogger(ShowRip.class);

    ShowRip(String label, String descr) {
	super(label, descr);
    }

    static private void showRipRoutes(CommandInterpreter interp) {

	String method = "rib.listRoutes";
	logger.debug("calling XMLRPC method " + method + " on URL " + BeraServices.RIB_URL);

	XmlRpcClientLite ribClient;
	try {
	    ribClient = new XmlRpcClientLite(BeraServices.RIB_URL);
	}
	catch (Exception e) {
            logger.error("could not create XML-RPC client: " + e);
	    return;
        }

	Vector params = new Vector();
	Object result;
	try {
	    result = ribClient.execute(method, params);
	}
	catch (Exception e) {
            logger.error("could not call XML-RPC method: " + e);
            return;
        }

	Vector routeList = (Vector) result;

	for (int i = 0; i < routeList.size(); ++i) {
	    Hashtable routeData = (Hashtable) routeList.get(i);

	    String protocol = (String) routeData.get("routeProtocol");

	    if (!protocol.equals("rip"))
		continue;

	    String instance = (String) routeData.get("routeProtocolInstance");
	    String addrFamily = (String) routeData.get("routeAddressFamily");
	    String network = (String) routeData.get("routeNetwork");
	    Integer prefixLength = (Integer) routeData.get("routePrefixLength");
	    String nextHop = (String) routeData.get("routeNextHop");

	    interp.send(protocol);
	    interp.send("/");
	    interp.send(instance);
	    interp.send(" ");
	    interp.send(addrFamily);
	    interp.send(" ");
	    interp.send(network);
	    interp.send("/");
	    interp.send(String.valueOf(prefixLength));
	    interp.send(" -> ");
	    interp.send(nextHop);
	    if (nextHop.equals(BeraConstants.IPV4_WILDCARD_STRING)) {
		interp.send(BeraConstants.SINGLE_BLANK_STRING);
		interp.send(BeraConstants.RECEIVE_STRING);
	    }
	    interp.sendLine(BeraConstants.EMPTY_STRING);
	}

    }

    void execute(CommandInterpreter interp, DoShow showCmd, String cmdLine, String cmdArgs[]) {
	logger.debug("FIXME: show rip route");
	showRipRoutes(interp);
    }
}

