/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: BooleanLeafValue.java,v 1.6 2003/11/15 00:06:06 evertonm Exp $

package bera.manager.config;

import java.util.Hashtable;

import bera.BeraAssert;
import bera.manager.LineSender;
import bera.manager.BadCommandException;

public class BooleanLeafValue extends ConfigValue {

    BooleanLeafValue(BooleanLeafNode node) {
	super(node);
    }

    public void listTree(LineSender sender, int depth, int inc) {
	ConfigNode.sendDepth(sender, depth);
	sender.sendLine(getConfigNode().getLabel());
    }

    public void setValue(LineSender sender, String args[], int firstArg) throws BadCommandException {
	BeraAssert.require(args.length > 0);
	BeraAssert.require(firstArg == args.length);

	// Nothing to do, we're always true
	// Otherwise, this value would not exist in config
    }

    public void rpcDump(Hashtable map) {
	map.put(getConfigNode().getLabel(), new Boolean(true));
    }

    public void saveTree(LineSender sender, String prefix) {
	sender.send(prefix);
	sender.sendLine(getConfigNode().getLabel());
    }
}

