/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: Inet4AddressLeafNode.java,v 1.5 2003/11/15 00:06:06 evertonm Exp $

package bera.manager.config;

import java.net.InetAddress;
import java.net.Inet4Address;
import java.net.UnknownHostException;

import bera.BeraAssert;
import bera.manager.LineSender;

public class Inet4AddressLeafNode extends LeafNode {

    ConfigValue createConfigValue(String value) throws BadValueException {
	BeraAssert.require(value != null); // reject auto enable
	return new Inet4AddressLeafValue(this, value); // calls checkValue()
    }

    public Inet4AddressLeafNode(String label) {
	super(label);
    }

    public void listTree(LineSender sender, int depth, int inc) {
	sendDepth(sender, depth);
	sender.sendLine(getLabel() + " INET4-ADDRESS");
    }

    Inet4Address checkValue(String value) throws BadValueException {
	InetAddress addr;
	try {
	    addr = InetAddress.getByName(value);
	}
	catch (UnknownHostException e) {
	    throw new BadValueException("could not solve INET4 address: " + value);
	}

	if (addr instanceof Inet4Address)
	    return (Inet4Address) addr;

	throw new BadValueException("invalid INET4 address: " + value);
    }
}

