/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: Inet4AddressLeafValue.java,v 1.5 2003/11/15 00:06:06 evertonm Exp $

package bera.manager.config;

import java.net.Inet4Address;
import java.util.Hashtable;

import bera.BeraAssert;
import bera.manager.LineSender;
import bera.manager.BadCommandException;

public class Inet4AddressLeafValue extends ConfigValue {

    Inet4Address addrValue;

    Inet4AddressLeafValue(Inet4AddressLeafNode node, String value) throws BadValueException {
	super(node);
	addrValue = node.checkValue(value); // throws BadValueException
    }

    public void listTree(LineSender sender, int depth, int inc) {
	ConfigNode.sendDepth(sender, depth);
	sender.sendLine(getConfigNode().getLabel() + " " + addrValue.getHostAddress());
    }

    public void setValue(LineSender sender, String args[], int firstArg) throws BadCommandException {
	int lastArg = args.length - 1;

	BeraAssert.require(args.length > 0);
	BeraAssert.require(firstArg == lastArg);

	String value = args[lastArg];

	try {
	    addrValue = ((Inet4AddressLeafNode) getConfigNode()).checkValue(value); // throws BadValueException
	}
	catch (BadValueException e) {
	    throw new BadCommandException("bad address: " + e.getMessage());
	}
    }

    public void rpcDump(Hashtable map) {
	//System.err.println("FIXME: Inet4AddressLeafValue.rpcDump(): " + getConfigNode().getLabel() + " => " + addrValue.getHostAddress());
	map.put(getConfigNode().getLabel(), addrValue.getHostAddress());
    }

    public void saveTree(LineSender sender, String prefix) {
	sender.send(prefix);
	sender.send(getConfigNode().getLabel());
	sender.send(" ");
	sender.sendLine(addrValue.getHostAddress());
    }
}

