/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: IntegerLeafNode.java,v 1.4 2003/11/11 14:05:13 evertonm Exp $

package bera.manager.config;

import bera.BeraAssert;
import bera.manager.LineSender;

public class IntegerLeafNode extends LeafNode {

    private int intMin;
    private int intMax;
    private int intDefault;

    ConfigValue createConfigValue(String value) throws BadValueException {
	BeraAssert.require(value != null); // reject auto enable for now
	int intValue = IntegerLeafValue.parseValue(value); // throws BadValueException
	return new IntegerLeafValue(this, intValue); // calls checkValue()
    }

    public IntegerLeafNode(String label, int minValue, int maxValue, int defaultValue) {
	super(label);
	intMin = minValue;
	intMax = maxValue;
	intDefault = defaultValue;
    }

    public void listTree(LineSender sender, int depth, int inc) {
	sendDepth(sender, depth);
	sender.sendLine(getLabel() + " INTEGER (default=" + intDefault + ") " + intMin + ".." + intMax);
    }

    void checkValue(int value) throws BadValueException {
	if (value < intMin)
	    throw new BadValueException("value lesser than min=" + intMin + ": " + value);
	if (value > intMax)
	    throw new BadValueException("value greater than max=" + intMax + ": " + value);
    }
}

