/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: InternalNode.java,v 1.5 2003/11/11 14:05:13 evertonm Exp $

package bera.manager.config;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;

import bera.BeraAssert;
import bera.manager.LineSender;

abstract class InternalNode extends ConfigNode {

    static private Logger logger = Logger.getLogger(InternalNode.class);

    private List childList = new ArrayList();

    InternalNode(String label) {
	super(label);
    }

    public void addChild(ConfigNode node) {
	BeraAssert.require(node != null);
	BeraAssert.require(findChild(node.getLabel()) == null);
	childList.add(node);
    }

    ConfigNode findChild(String nodeLabel) {
	for (int i = 0; i < childList.size(); ++i) {
	    ConfigNode node = (ConfigNode) childList.get(i);
	    if (nodeLabel.equals(node.getLabel()))
		return node;
	}
	return null;
    }

    protected void listChildren(LineSender sender, int depth, int inc) {
	for (int i = 0; i < childList.size(); ++i) {
	    ConfigNode node = (ConfigNode) childList.get(i);
	    node.listTree(sender, depth, inc);
	}
    }

    void enableAutomaticChildrenValues(List valueList) {
	for (int i = 0; i < childList.size(); ++i) {
	    ConfigNode node = (ConfigNode) childList.get(i);

	    // if (node instanceof AutoNode) -> ((AutoNode) node.createConfigValue()

	    if (node.autoEnable()) {
		ConfigValue configValue;
		try {
		    configValue = node.createConfigValue(null);
		}
		catch (BadValueException e) {
		    logger.error("failure creating automatic value for child: " + e);
		    continue;
		}
		BeraAssert.require(configValue != null);
		valueList.add(configValue);
	    }
	}
    }

    boolean autoEnable() {
	// FIXME: this should be set on a per-node basis, in the constructor,
	//        if the corresponding node supports default value and
	//        is supposed to be automatically turned on ("auto-enable")
	return false;
    }

    ConfigValue createConfigValue(String value) throws BadValueException {
	// FIXME: for now, creation of ConfigValue (needed for
	//        "auto-enable" of the node) is unsupported for
	//        InternalNode
	BeraAssert.require(false);
	return null;
    }
}


