/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: MultiValue.java,v 1.4 2003/11/10 01:35:49 evertonm Exp $

package bera.manager.config;

import bera.manager.LineSender;

public class MultiValue extends InternalValue {

    private String valueName;

    public MultiValue(MultiNode node, String name) {
	super(node);
	valueName = name;
    }

    public String getName() {
	return valueName;
    }

    public void listTree(LineSender sender, int depth, int inc) {
	ConfigNode.sendDepth(sender, depth);
	sender.sendLine(getConfigNode().getLabel() + " " + valueName + " {");
	listChildren(sender, depth + inc, inc);
	ConfigNode.sendDepth(sender, depth);
	sender.sendLine("}");
    }

    public void saveTree(LineSender sender, String prefix) {
	sender.send(prefix);
	String label = getConfigNode().getLabel();
	sender.send(label);
	sender.send(" ");
	sender.sendLine(valueName);

	for (int i = 0; i < childList.size(); ++i) {
	    ConfigValue value = (ConfigValue) childList.get(i);
	    value.saveTree(sender, prefix + label + " " + valueName + " ");
	}
    }
}

