/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: SingleValue.java,v 1.2 2003/11/09 17:38:14 evertonm Exp $

package bera.manager.config;

import bera.manager.LineSender;

public class SingleValue extends InternalValue {

    public SingleValue(SingleNode node) {
	super(node);
    }

    public void listTree(LineSender sender, int depth, int inc) {
	ConfigNode.sendDepth(sender, depth);
	sender.sendLine(getConfigNode().getLabel() + " {");
	listChildren(sender, depth + inc, inc);
	ConfigNode.sendDepth(sender, depth);
	sender.sendLine("}");
    }

    public void saveTree(LineSender sender, String prefix) {
	sender.send(prefix);
	String label = getConfigNode().getLabel();
	sender.sendLine(label);

	for (int i = 0; i < childList.size(); ++i) {
	    ConfigValue value = (ConfigValue) childList.get(i);
	    value.saveTree(sender, prefix + label + " ");
	}
    }
}


