/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: BeraInterfaceAddress.java,v 1.4 2003/11/18 00:16:46 evertonm Exp $

package bera.net;

import java.net.InetAddress;

import org.apache.log4j.Logger;

import bera.util.Conversion;

public class BeraInterfaceAddress {

    static private final Logger logger = Logger.getLogger(BeraInterfaceAddress.class);

    private InetAddress ifaceAddress;
    private int         ifacePrefixLength;

    public static void forceNetworkPrefix(byte[] addr, int prefixLength) {
	// Fix last Significant byte
	int last = prefixLength >> 3; // last = len / 8
	if (last >= addr.length)
	    return;
	addr[last] &= (0xFF << (8 - (prefixLength & 7)));

	// Clear non-significant bytes
	for (int i = last + 1; i < addr.length; ++i)
	    addr[i] = 0;
    }

    public BeraInterfaceAddress(InetAddress addr, int prefixLength) {
	ifaceAddress      = addr;
	ifacePrefixLength = prefixLength;
    }

    public InetAddress getAddress() {
	return ifaceAddress;
    }

    public int getPrefixLength() {
	return ifacePrefixLength;
    }

    // Does 'addr' belong to the same network as this object?
    public boolean sameNetwork(InetAddress addr) {
	byte[] ifaceAddrBuf = ifaceAddress.getAddress();
	byte[] addrBuf = addr.getAddress();

	if (ifaceAddrBuf.length != addrBuf.length)
	    return false;

	int bufLen = ifaceAddrBuf.length;

	byte[] mask = new byte[bufLen];

	Conversion.lengthToMask(mask, bufLen, 0, ifacePrefixLength);

	int lastByte = ifacePrefixLength >> 3; // last = len / 8

	for (int i = 0; i <= lastByte; ++i) {
	    byte m = mask[i];
	    if ((ifaceAddrBuf[i] & m) != (addrBuf[i] & m))
		return false;
	}

	return true;
    }

    public boolean sameNetwork(InetAddress netAddr, int prefixLength) {
	if (prefixLength != ifacePrefixLength)
	    return false;

	return sameNetwork(netAddr);
    }
}
