/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: BeraNetworkInterface.java,v 1.7 2003/12/01 10:50:59 evertonm Exp $

package bera.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.ArrayList;
import java.util.Vector;
import java.util.Hashtable;

import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClientLite;

import bera.BeraServices;
import bera.util.Conversion;

public class BeraNetworkInterface {

    static private final Logger logger = Logger.getLogger(BeraNetworkInterface.class);

    private String  ifaceName;
    private int     ifaceMetric;
    private boolean ifaceMultiaccess; // there can be more than one neighbor on same interface?
    private boolean ifaceBroadcast;   // broadcast/multicast reaches all neighbors?
    private List    ifaceAddrList;

    public BeraNetworkInterface(String name, int metric, boolean multiaccess, boolean broadcast, List addrList) {
	ifaceName        = name;
	ifaceMetric      = metric;
	ifaceMultiaccess = multiaccess;
	ifaceBroadcast   = broadcast;
	ifaceAddrList    = addrList;
    }

    public String getName() {
	return ifaceName;
    }

    /*
    public void addAddress(InetAddress addr, int prefixLength) {
	ifaceAddrList.add(new BeraInterfaceAddress(addr, prefixLength));
    }
    */

    public List getAddresses() {
	return ifaceAddrList;
    }

    public int getMetric() {
	return ifaceMetric;
    }

    public boolean multiaccess() {
	return ifaceMultiaccess;
    }

    public boolean broadcast() {
	return ifaceBroadcast;
    }

    public static Vector feaFetchInterfaces() { 

	logger.debug("fetching interfaces from FEA");

	String method = "fea.listInterfaces";
	logger.debug("calling XMLRPC method " + method + " on URL " + BeraServices.FEA_URL);

	XmlRpcClientLite client;
	try {
	    client = new XmlRpcClientLite(BeraServices.FEA_URL);
	}
	catch (Exception e) {
            logger.error("could not create XML-RPC client: " + e);
	    return null;
        }

	Object result;
	Vector params = new Vector();
	try {
	    result = client.execute(method, params);
	}
	catch (Exception e) {
            logger.error("could not call XML-RPC method: " + e);
            return null;
        }

	Vector ifaceList = (Vector) result;

	return ifaceList;
    }

    public static List makeInterfaceList(Vector rpcIfaceList) {

	if (rpcIfaceList == null)
	    return null;

	List ifaceList = new ArrayList();

	Enumeration ifaceEnum = rpcIfaceList.elements();
	while (ifaceEnum.hasMoreElements()) {
	    Hashtable iface = (Hashtable) ifaceEnum.nextElement();

	    String ifaceName = (String) iface.get("interfaceName");
	    int ifaceMetric = ((Integer) iface.get("interfaceMetric")).intValue();
	    boolean ifaceMultiaccess = ((Boolean) iface.get("interfaceCanMultiaccess")).booleanValue();
	    boolean ifaceBroadcast = ((Boolean) iface.get("interfaceCanBroadcast")).booleanValue();
	    Vector ifaceAddrList = (Vector) iface.get("interfaceInetAddresses");

	    List addrList = new ArrayList();

	    Enumeration addrEnum = ifaceAddrList.elements();
	    while (addrEnum.hasMoreElements()) {
		Hashtable addrData = (Hashtable) addrEnum.nextElement();
		String addrFamily = (String) addrData.get("addressFamily");
		String addrValue = (String) addrData.get("addressValue");

		InetAddress addr;
		try {
		    addr = InetAddress.getByName(addrValue);
		}
		catch (UnknownHostException e) {
		    logger.error("can't solve interface address: " + e);
		    continue;
		}

	        int addrPrefixLength = ((Integer) addrData.get("addressPrefixLength")).intValue();

		//logger.debug("iface: name=" + ifaceName + " metric=" + ifaceMetric + " addr=" + addrFamily + "/" + addrValue + "/" + addrPrefixLength);

		addrList.add(new BeraInterfaceAddress(addr, addrPrefixLength));
	    }

	    ifaceList.add(new BeraNetworkInterface(ifaceName, ifaceMetric, ifaceMultiaccess, ifaceBroadcast, addrList));
	}

	return ifaceList;
    }
}
