/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: RibRoute.java,v 1.1 2003/11/13 01:34:18 evertonm Exp $

package bera.rib;

import java.util.Hashtable;

import org.apache.log4j.Logger;

class RibRoute {
    static private Logger logger = Logger.getLogger(RibRoute.class);

    private String routeProtocol;
    private String routeProtocolInstance;
    private String routeAddressFamily;
    private String routeNetworkAddress;
    private int    routePrefixLength;
    private String routeNextHop;

    RibRoute(String protocol, String instance, String addrFamily, String network, int prefixLen, String nextHop) {
	routeProtocol = protocol;
	routeProtocolInstance = instance;
	routeAddressFamily = addrFamily;
	routeNetworkAddress = network;
	routePrefixLength = prefixLen;
	routeNextHop = nextHop;
    }

    Hashtable rpcDump() {
	Hashtable routeData = new Hashtable();

	routeData.put("routeProtocol", routeProtocol);
	routeData.put("routeProtocolInstance", routeProtocolInstance);
	routeData.put("routeAddressFamily", routeAddressFamily);
	routeData.put("routeNetwork", routeNetworkAddress);
	routeData.put("routePrefixLength", new Integer(routePrefixLength));
	routeData.put("routeNextHop", routeNextHop);

	return routeData;
    }

    public boolean equals(Object obj) {
	if (obj == null)
	    return false;

	if (obj == this)
	    return true;

	if (!(obj instanceof RibRoute))
	    return false;

	RibRoute route = (RibRoute) obj;

	if (!routeProtocol.equals(route.routeProtocol))
	    return false;

	if (!routeProtocolInstance.equals(route.routeProtocolInstance))
	    return false;

	if (!routeAddressFamily.equals(route.routeAddressFamily))
	    return false;

	if (!routeNetworkAddress.equals(route.routeNetworkAddress))
	    return false;

	if (routePrefixLength != route.routePrefixLength)
	    return false;

	if (!routeNextHop.equals(route.routeNextHop))
	    return false;

	return true;
    }
}

