/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: RibRouteTable.java,v 1.3 2003/11/19 00:38:10 evertonm Exp $

package bera.rib;

import java.util.Set;
import java.util.Vector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Hashtable;

import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

import bera.BeraServices;
import bera.BeraConstants;

class RibRouteTable {
    static private Logger logger = Logger.getLogger(RibRouteTable.class);

    private Set routeSet = new HashSet();

    private void feaRpc(String method, Vector params) {
	logger.debug("calling XMLRPC method " + method + " on URL " + BeraServices.FEA_URL);

	XmlRpcClientLite ribClient;
	try {
	    ribClient = new XmlRpcClientLite(BeraServices.FEA_URL);
	}
	catch (Exception e) {
            logger.error("could not create XML-RPC client: " + e);
	    return;
        }

	try {
	    Object result = ribClient.execute(method, params);
	}
	catch (Exception e) {
            logger.error("could not call XML-RPC method: " + e);
            return;
        }
    }

    private void feaAdd(RibRoute route) {
	Hashtable routeInfo = route.rpcDump();

	Vector routeList = new Vector();
	routeList.add(routeInfo);

	Vector params = new Vector();
	params.add(routeList);

	feaRpc("fea.addRoutes", params);
    }

    private void feaWithdraw(RibRoute route) {
	Hashtable routeInfo = route.rpcDump();

	Vector routeList = new Vector();
	routeList.add(routeInfo);

	Vector params = new Vector();
	params.add(routeList);

	feaRpc("fea.withdrawRoutes", params);
    }

    synchronized void add(String protocol, String instance, String addrFamily, String network, int prefixLen, String nextHop) {
	logger.debug("add entry: " + protocol + "/" + instance + ": " + addrFamily + "/" + network + "/" + prefixLen + "->" + nextHop);

	RibRoute route = new RibRoute(protocol, instance, addrFamily, network, prefixLen, nextHop);
	if (routeSet.add(route)) {

	    // Don't add directly connected routes to FEA,
	    // as this is a kernel job
	    if (nextHop.equals(BeraConstants.IPV4_WILDCARD_STRING))
		return;

	    feaAdd(route);
	}
    }

    synchronized void del(String protocol, String instance, String addrFamily, String network, int prefixLen, String nextHop) {
	logger.debug("del entry: " + protocol + "/" + instance + ": " + addrFamily + "/" + network + "/" + prefixLen + "->" + nextHop);

	RibRoute route = new RibRoute(protocol, instance, addrFamily, network, prefixLen, nextHop);
	if (routeSet.remove(route)) {

	    // Don't remove directly connected routes from FEA,
	    // as this is a kernel job
	    if (nextHop.equals(BeraConstants.IPV4_WILDCARD_STRING))
		return;

	    feaWithdraw(route);
	}
    }

    synchronized Vector rpcDump() {

	Vector routeList = new Vector();

	for (Iterator it = routeSet.iterator(); it.hasNext(); ) {
	    RibRoute route = (RibRoute) it.next();
	    Hashtable routeData = route.rpcDump();
	    routeList.add(routeData);
	}

	return routeList;
    }
}

