/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: RibRpcHandler.java,v 1.7 2003/11/17 11:00:36 evertonm Exp $

package bera.rib;

import java.util.Enumeration;
import java.util.Vector;
import java.util.Hashtable;
import java.net.SocketException;
import java.net.InetAddress;
import java.io.IOException;

//import org.apache.log4j.Logger;

public class RibRpcHandler {

    //static private Logger logger = Logger.getLogger(RibRpcHandler.class);

    static private final Vector emptyVector = new Vector();

    private RibRouteTable routeTable = new RibRouteTable();

    public Vector addRoutes(Vector routeList) {
	//logger.debug("addRoutes called");

	int size = routeList.size();
	for (int i = 0; i < size; ++i) {
	    Hashtable route = (Hashtable) routeList.get(i);

	    String routeProtocol = (String) route.get("routeProtocol");
	    String routeProtocolInstance = (String) route.get("routeProtocolInstance");
	    String routeAddressFamily = (String) route.get("routeAddressFamily");
	    String routeNetwork  = (String) route.get("routeNetwork");
	    int    routePrefixLength = ((Integer) route.get("routePrefixLength")).intValue();
	    String routeNextHop      = (String) route.get("routeNextHop");

	    routeTable.add(routeProtocol, routeProtocolInstance,
			   routeAddressFamily, routeNetwork,
			   routePrefixLength, routeNextHop);
	}

	return emptyVector;
    }

    public Vector withdrawRoutes(Vector routeList) {
	//logger.debug("withdrawRoutes called");

	int size = routeList.size();
	for (int i = 0; i < size; ++i) {
	    Hashtable route = (Hashtable) routeList.get(i);

	    String routeProtocol = (String) route.get("routeProtocol");
	    String routeProtocolInstance = (String) route.get("routeProtocolInstance");
	    String routeAddressFamily = (String) route.get("routeAddressFamily");
	    String routeNetwork  = (String) route.get("routeNetwork");
	    int    routePrefixLength = ((Integer) route.get("routePrefixLength")).intValue();
	    String routeNextHop      = (String) route.get("routeNextHop");

	    routeTable.del(routeProtocol, routeProtocolInstance,
			   routeAddressFamily, routeNetwork,
			   routePrefixLength, routeNextHop);
	}

	return emptyVector;
    }

    public Vector listRoutes() {
	return routeTable.rpcDump();
    }
}

