/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: RipConfig.java,v 1.9 2003/11/09 16:27:10 evertonm Exp $

package bera.rip;

import java.util.Enumeration;
import java.util.Hashtable;
import java.net.InetAddress;

import org.apache.log4j.Logger;

import bera.BeraAssert;

class RipConfig  {

    static private final Logger logger = Logger.getLogger(RipConfig.class);

    private static final int RIP_PULSE_INTERVAL   = 5;
    private static final int RIP_TRIGGER_HOLDTIME = 5;
    private static final int RIP_UPDATE_INTERVAL  = 30;
    private static final int RIP_TIMER_TIMEOUT    = 180;
    private static final int RIP_TIMER_GARBAGE    = 120;

    private Hashtable configMap = new Hashtable();


    void update(Hashtable config) {
	configMap = config;
	/*
	if (configMap == null)
	    return;

	for (Enumeration enum = configMap.keys(); enum.hasMoreElements(); ) {
	    String str = (String) enum.nextElement();
	    logger.debug("rip config key: " + str);
	}

	logger.debug("rip config pulse-interval: " + getRipPulseInterval());
	logger.debug("rip config trigger-holdtime: " + getRipTriggerHoldtime());
	logger.debug("rip config update-interval: " + getRipUpdateInterval());
	logger.debug("rip config timeout: " + getRipTimerTimeout());
	logger.debug("rip config garbage: " + getRipTimerGarbage());
	*/
    }

    int getRipPulseInterval() {
	if (configMap == null)
	    return RIP_PULSE_INTERVAL;

	Integer intValue = (Integer) configMap.get("pulse-interval");
	if (intValue == null)
	    return RIP_PULSE_INTERVAL;

	return intValue.intValue();
    }

    int getRipTriggerHoldtime() {
	if (configMap == null)
	    return RIP_TRIGGER_HOLDTIME;

	Integer intValue = (Integer) configMap.get("holdtime");
	if (intValue == null)
	    return RIP_TRIGGER_HOLDTIME;

	return intValue.intValue();
    }

    int getRipUpdateInterval() {
	if (configMap == null)
	    return RIP_UPDATE_INTERVAL;

	Integer intValue = (Integer) configMap.get("update-interval");
	if (intValue == null)
	    return RIP_UPDATE_INTERVAL;

	return intValue.intValue();
    }

    int getRipTimerTimeout() {
	if (configMap == null)
	    return RIP_TIMER_TIMEOUT;

	Integer intValue = (Integer) configMap.get("timeout");
	if (intValue == null)
	    return RIP_TIMER_TIMEOUT;

	return intValue.intValue();
    }

    int getRipTimerGarbage() {
	if (configMap == null)
	    return RIP_TIMER_GARBAGE;

	Integer intValue = (Integer) configMap.get("garbage");
	if (intValue == null)
	    return RIP_TIMER_GARBAGE;

	return intValue.intValue();
    }

    boolean usePoisonedReverse(InetAddress ifaceAddr) {
	logger.debug("FIXME: check poisoned reverse config for interface");
	return true;
    }
}
