/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: RipMulticastListener.java,v 1.13 2003/12/30 15:31:33 evertonm Exp $

package bera.rip;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Iterator;

import org.apache.log4j.Logger;

import bera.BeraListen;
import bera.BeraAssert;
import bera.BeraConstants;
import bera.net.BeraInterfaceAddress;

class RipMulticastListener extends Thread {

    static private final Logger logger = Logger.getLogger(RipMulticastListener.class);

    private RipServer       ripServer;
    //private InetAddress     ripMulticastAddress;
    private MulticastSocket ripMulticastSocket;
    private DatagramPacket  ripMulticastPacket;

    private void addInterface(InetAddress ifaceAddr) throws BeraListen {

	// select interface
	try {
	    ripMulticastSocket.setInterface(ifaceAddr);
	}
	catch (SocketException e) {
	    logger.error("could not set multicast interface to '" + ifaceAddr.getHostAddress() + "': " + e);
	    throw new BeraListen(e);
	}

	// sanity check on interface
	InetAddress ifaceAddress;
	try {
	    ifaceAddress = ripMulticastSocket.getInterface();
	}
	catch (SocketException e) {
	    logger.error("could not get multicast interface: " + e);
	    throw new BeraListen(e);
	}
	BeraAssert.require(ifaceAddress.equals(ifaceAddr));

	/*
        try {
	    ripMulticastAddress = InetAddress.getByName(RipServer.RIP_MULTICAST_ADDRESS);
        }
        catch (UnknownHostException e) {
            logger.error("could not solve multicast address: " + e);
            throw new BeraListen(e);
        }
	*/

	InetAddress ripMulticastAddress = BeraConstants.getRipMulticastAddress();

	// join multicast address on interface
	try {
	    //ripMulticastSocket.joinGroup(ripMulticastAddress);
	    //ripMulticastSocket.joinGroup(BeraConstants.RIP_MULTICAST_INET_ADDRESS);
	    ripMulticastSocket.joinGroup(ripMulticastAddress);
	}
	catch (IOException e) {
            logger.error("could not join multicast group '" + ripMulticastAddress.getHostAddress() + "' on interface '" + ifaceAddress.getHostAddress() + "': " + e);
	    throw new BeraListen(e);
	}

	logger.error("joined group '" + ripMulticastAddress.getHostAddress() + "' on interface: " + ifaceAddress.getHostAddress());
    }

    RipMulticastListener(RipServer server, Iterator addrIt) throws BeraListen {

	// Create socket

	try {
            ripMulticastSocket = new MulticastSocket(RipServer.RIP_UDP_PORT);
	}
	catch (SocketException e) {
            logger.error("socket: could not create server socket: " + e);
            throw new BeraListen(e);
	}
	catch (IOException e) {
            logger.error("IO: could not create server socket: " + e);
            throw new BeraListen(e);
	}

	// Disable loopback mode

	try {
	    ripMulticastSocket.setLoopbackMode(true);
	}
	catch (SocketException e) {
	    logger.warn("could not disable loopback mode: " + e);
	}

	// Join multicast group on every interface

	while (addrIt.hasNext()) {
	    BeraInterfaceAddress ifaceAddr = (BeraInterfaceAddress) addrIt.next();
	    addInterface(ifaceAddr.getAddress());
	}

	ripServer          = server;
	byte[] buffer      = new byte[RipPacket.PACKET_MAX_SIZE];
	ripMulticastPacket = new DatagramPacket(buffer, buffer.length);
    }

    public void run() {

	logger.debug("waiting multicast packets");

	for (;;) {
	    try {
		ripMulticastSocket.receive(ripMulticastPacket);
	    }
	    catch (IOException e) {
		logger.error("failure receiving packet: " + e);
	    }
	    
	    ripServer.multicastPacketCall(ripMulticastPacket);
	}
    }

    /*
    void send(DatagramPacket packet) throws IOException {
	ripMulticastSocket.send(packet);
    }
    */
}
