/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: TelnetServer.java,v 1.3 2003/10/31 02:11:23 evertonm Exp $

package bera.telnet;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.ServerSocket;

import org.apache.log4j.Logger;

public class TelnetServer extends Thread {

    static private Logger logger = Logger.getLogger(TelnetServer.class);

    private int           listenPort;
    private TelnetHandler telnetHandler;
    private ServerSocket  serverSocket;

    public TelnetServer(int port, TelnetHandler handler) throws IOException {
	listenPort = port;
	telnetHandler = handler;

	logger.debug("binding to port: " + listenPort);

	try {
	    serverSocket = new ServerSocket(listenPort);
	} catch (IOException e) {
	    logger.error("could not listen on port: " + listenPort + ": " + e);
	    throw e;
	}
    }

    public void run() {

	logger.debug("listening");

	for (;;) {

	    Socket clientSocket = null;
	    try {
		clientSocket = serverSocket.accept();
	    } catch (IOException e) {
		logger.error("accept failed: " + e);
		continue;
	    }

	    TelnetClientTask telnetClient = new TelnetClientTask(clientSocket, telnetHandler);

	    telnetClient.start();
	}
    }
}

