/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: Conversion.java,v 1.6 2003/10/19 02:50:40 evertonm Exp $

package bera.util;

import bera.BeraAssert;

public class Conversion {

    static public void lengthToMask(byte[] buffer, int size, int offset, int prefixLength) {
	BeraAssert.require(size > 0);
	BeraAssert.require(size <= buffer.length);
	BeraAssert.require(offset >= 0);
	BeraAssert.require(offset < buffer.length);
	BeraAssert.require(offset + size <= buffer.length);

	int last = prefixLength >> 3; // last = len / 8
	for (int i = 0; i < last; ++i)
	    buffer[offset + i] = (byte) 0xFF;
	buffer[offset + last] = (byte) (0xFF << (8 - (prefixLength & 7)));
	for (int i = last + 1; i < size; ++i)
	    buffer[offset + i] = 0;
    }

    private static String maskToStr(byte[] buffer) {
	String str = "";

	for (int i = 0; i < buffer.length; ++i)
	    str += (0xFF & buffer[i]) + ".";

	return str;
    }

    static public int maskToLength(byte[] buffer) {
	int prefixLength = 0;
	int octet;
	

	for (int i = 0; i < buffer.length; ++i) {
	    octet = 0xFF & buffer[i];
	    if (octet != 0xFF) {
		while (octet > 0) {
		    octet <<= 1;
		    octet &= 0xFF;
		    ++prefixLength;
		}
		break;
	    }
	    prefixLength += 8;
	}

	//System.err.println("ERASEME: Conversion.maskToLength: " + maskToStr(buffer) + "->" + prefixLength);

	return prefixLength;
    }

    static public void intToByte(byte[] buffer, int offset, int value) {
	buffer[offset + 3] = (byte) (value & 0xFF);
	value >>= 8;
	buffer[offset + 2] = (byte) (value & 0xFF);
	value >>= 8;
	buffer[offset + 1] = (byte) (value & 0xFF);
	value >>= 8;
	buffer[offset] = (byte) value;
    }

    static public void shortToByte(byte[] buffer, int offset, int value) {
	buffer[offset + 1] = (byte) (value & 0xFF);
	value >>= 8;
	buffer[offset] = (byte) value;
    }

    static public int byteToInt(byte[] buffer, int offset) {
	int sum = (int) (0xFF & buffer[offset]);

	++offset;
	sum <<= 8;
	sum += (int) (0xFF & buffer[offset]);

	++offset;
	sum <<= 8;
	sum += (int) (0xFF & buffer[offset]);

	++offset;
	sum <<= 8;
	sum += (int) (0xFF & buffer[offset]);

	return sum;
    }

    static public int byteToShort(byte[] buffer, int offset) {
	int sum = (int) (0xFF & buffer[offset]);

	++offset;
	sum <<= 8;
	sum += (int) (0xFF & buffer[offset]);

	return sum;
    }
}


