/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: Matcher.java,v 1.1 2003/11/15 00:06:07 evertonm Exp $

package bera.util.regex;

import org.apache.regexp.RE;

import bera.BeraAssert;

public class Matcher {

    private Pattern pat;
    private RE re;
    
    String search = null;

    Matcher(Pattern p, String exp) {
	pat = p;
	re = new RE(exp);
    }

    public boolean matches() {
	BeraAssert.require(search != null);
	return re.match(search);
    }

    public String group(int group) {
	BeraAssert.require(search != null);
	return re.getParen(group);
    }
}


