/*-GNU-GPL-BEGIN-*
  bera - Buriti Experimental Routing Architecture
  Copyright (C) 2003  Everton da Silva Marques

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*-GNU-GPL-END-*/

// $Id: FeaRpcTest.java,v 1.3 2003/10/21 22:58:40 evertonm Exp $

package bera.fea;

import java.util.Vector;
import java.io.IOException;
import java.net.MalformedURLException;

import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

import bera.BeraServices;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class FeaRpcTest extends TestCase {

    FeaEngineAdaptor feaAdaptor  = null;
    FeaRpcHandler    rpcHandler  = null;
    WebServer        webServer   = null;
    XmlRpcClientLite rpcClient   = null;
    Vector           emptyParams = null;

    public FeaRpcTest(String name) {
	super(name);
    }

    protected void setUp() {

	feaAdaptor  = new FeaEngineDummy();
	rpcHandler  = new FeaRpcHandler(feaAdaptor);
	webServer   = new WebServer(BeraServices.FEA_PORT);

	try {
	    rpcClient = new XmlRpcClientLite(BeraServices.FEA_URL);
	}
	catch (MalformedURLException e) {
	}

	emptyParams = new Vector();

	assertNotNull(feaAdaptor);
	assertNotNull(rpcHandler);
	assertNotNull(webServer);
	assertNotNull(rpcClient);
	assertNotNull(emptyParams);

	webServer.addHandler("fea", rpcHandler);

	webServer.start();
    }

    protected void tearDown() {
	webServer.shutdown();
    }

    public void testIfaceListConstancy() {

	assertNotNull(feaAdaptor);
	assertNotNull(rpcHandler);
	assertNotNull(webServer);
	assertNotNull(rpcClient);
	assertNotNull(emptyParams);

	Vector once  = rpcHandler.listInterfaces();
	Vector again = rpcHandler.listInterfaces();

	assertEquals(once, again);
    }

    public void testTransportConstancy() {

	assertNotNull(feaAdaptor);
	assertNotNull(rpcHandler);
	assertNotNull(webServer);
	assertNotNull(rpcClient);
	assertNotNull(emptyParams);

	Vector once  = null;
	Vector again = null;

	try {
	    once  = (Vector) rpcClient.execute("fea.listInterfaces", emptyParams);
	    again = (Vector) rpcClient.execute("fea.listInterfaces", emptyParams);
	}
	catch (XmlRpcException e) {
	}
	catch (IOException e) {
	}

	assertNotNull(once);
	assertNotNull(again);

	assertEquals(once, again);
    }

    public void testRpcTransport() {

	assertNotNull(feaAdaptor);
	assertNotNull(rpcHandler);
	assertNotNull(webServer);
	assertNotNull(rpcClient);
	assertNotNull(emptyParams);

	Vector desiredIfaceList     = rpcHandler.listInterfaces();
	Vector transportedIfaceList = null;

	try {
	    transportedIfaceList = (Vector) rpcClient.execute("fea.listInterfaces", emptyParams);
	}
	catch (XmlRpcException e) {
	}
	catch (IOException e) {
	}

	assertNotNull(transportedIfaceList);

	assertEquals(desiredIfaceList, transportedIfaceList);
    }

    public static Test suite() {

	TestSuite suite = new TestSuite(FeaRpcTest.class); 

	/*
	  // OR:

	  TestSuite suite = new TestSuite(); 
	  suite.addTest(new FeaRpcTest("testIfaceListConstancy")); 
	  suite.addTest(new FeaRpcTest("testTransportConstancy")); 
	  suite.addTest(new FeaRpcTest("testRpcTransport")); 
	*/

	return suite;
    }
}
