/*
 * SkipPageException.java.
 * 
 * Copyright (c) 2002 by Free Software Foundation, Inc.
 * Written by Arnaud Vandyck <arnaud.vandyck@ulg.ac.be>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation, version 2. (see COPYING.LIB)
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation  
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA
 */

package javax.servlet.jsp;


/**
 * This page must stop evaluation.
 *
 * @author {@link mailto:arnaud.vandyck@ulg.ac.be Arnaud Vandyck}
 */
public class SkipPageException extends JspException
{

  /** 
   */
  public SkipPageException ()
  {
    super("jsp skip page problem");
  }

  /** 
   */
  public SkipPageException (String message)
  {
    super(message);
  }
  
  public SkipPageException (String message,
                            Throwable rootCause)
  {
    super(message, rootCause);
  }

  public SkipPageException (Throwable rootCause)
  {
    super(rootCause);
  }

}
