package freenet;

import freenet.node.NodeReference;

/**
 * @author Iakin
 *
 * Utility for sorting ConnectionHandlers
 * */
		public class ConnectionHandlerComparator implements java.util.Comparator 
		{
			private int iCompareMode =0;
			private ConnectionHandlerComparator secondary;
			public ConnectionHandlerComparator(int iCompareMode)
			{
				this(iCompareMode,null);
			}
			
			public ConnectionHandlerComparator(int iCompareMode,ConnectionHandlerComparator secondarySorting)
			{
				this.iCompareMode = iCompareMode;
				this.secondary = secondarySorting;
			}
    	
			public int compare(Object o1,Object o2)
			{
				return compare ((ConnectionHandler)o1,(ConnectionHandler)o2);
			}
			
			private int secondaryCompare(int iSign,int primaryResult,ConnectionHandler ch1,ConnectionHandler ch2)
			{
				if(primaryResult == 0 && secondary != null)
					return secondary.compare(ch1,ch2);
				else
					return iSign*primaryResult; 	
			}
			
			//public int compare(ConnectionHandler ch1,ConnectionHandler ch2)
			//{
			//	return compare(iCompareMode<0?-1:1,ch1,ch2);
			//}

    	
			public int compare(ConnectionHandler ch1,ConnectionHandler ch2)
			{
				int iSign = iCompareMode<0?-1:1;
				switch(Math.abs(iCompareMode))
				{
					case 0: //No sorting
						return 0;
					case 1:
						return secondaryCompare(iSign,ch1.peerAddress().toString().compareTo(ch2.peerAddress().toString()),ch1,ch2); //TODO: replace with proper IP address comparision
					case 2:
						return secondaryCompare(iSign,ch1.peerIdentity().toString().compareTo(ch2.peerIdentity().toString()),ch1,ch2);
					case 3:
						return secondaryCompare(iSign,new Integer(ch1.sendingCount()).compareTo(new Integer(ch2.sendingCount())),ch1,ch2);
					case 4:
						return secondaryCompare(iSign,new Long(ch1.sendQueueSize()).compareTo(new Long(ch2.sendQueueSize())),ch1,ch2);	
					case 5:
						return secondaryCompare(iSign,new Boolean(ch1.receiving()).toString().compareTo(new Boolean(ch2.receiving()).toString()),ch1,ch2);
					case 6:
						return secondaryCompare(iSign,new Long(ch1.messages()).compareTo(new Long(ch2.messages())),ch1,ch2);
					case 7:
						return secondaryCompare(iSign,new Long(ch1.idleTime()).compareTo(new Long(ch2.idleTime())),ch1,ch2);
					case 8:
						return secondaryCompare(iSign,new Long(ch1.runTime()).compareTo(new Long(ch2.runTime())),ch1,ch2);
					case 9:
						return secondaryCompare(iSign,new Boolean(ch1.outbound).toString().compareTo(new Boolean(ch2.outbound).toString()),ch1,ch2);
					case 10:
						return secondaryCompare(iSign,new Boolean(ch1.sending()).toString().compareTo(new Boolean(ch2.sending()).toString()),ch1,ch2);
					case 11:
						{
							NodeReference n1 = freenet.node.Main.node.rt.getNodeReference(ch1.peerIdentity());
							NodeReference n2 = freenet.node.Main.node.rt.getNodeReference(ch2.peerIdentity());
							String s1=(n1==null?"":(n1.physical.length >0?n1.physical[1]:""));
							String s2=(n2==null?"":(n2.physical.length >0?n2.physical[1]:""));
							return secondaryCompare(iSign,s2.compareTo(s1),ch1,ch2); //Reverse order on s1 and s2 is intended. Better to place non-routable CH:s at the end
						}
						
					default:
						return 0;	
				}
			}
		}
