package freenet;

import java.util.Hashtable;
import java.util.Enumeration;
import freenet.support.Comparable;
public class ContactCounter {

    public static class Record implements Cloneable, Comparable {
        public String addr = "";
        public int totalContacts = 1;
        public int successes = 0;
        public int activeContacts = 0;


        protected Record(String addr) {
            this.addr = addr;
        }

        protected final Object clone() {
            Object ret = null;
            try {
                ret = super.clone();
            }
            catch (CloneNotSupportedException wtf) {
                // REDFLAG: butt ugly. What is the standard idiom for this?
            }
            return ret;
        }

        public final int compareTo(Object o) {
            if (!(o instanceof Record)) {
                throw new IllegalArgumentException("Not a ContactCounter.Record.");
            }
 
            final int delta = ((Record)o).totalContacts - totalContacts;

            if (delta == 0) {
                return 0;
            }
            if (delta > 0) {
                return 1;
            }
            return -1;
        }
    }

    public final synchronized void incTotal(String addr) {
        addr = cannonicalAddr(addr);
        Record entry = (Record)table.get(addr);
        if (entry == null) {
            //System.err.println("ContactCounter.incTotal -- added: " + addr);
            table.put(addr, new Record(addr));
        }
        else {
            entry.totalContacts++;
        }
    }

    // Must call incTotal first.
    public final synchronized void incSuccesses(String addr) {
        addr = cannonicalAddr(addr);
        Record entry = (Record)table.get(addr);
        if (entry != null) {
            entry.successes++;
        }
        else {
            //System.err.println("ContactCounter.incSuccesses -- unknown addr: " + addr);
        }
    }


    public final synchronized void incActive(String addr) {
        addr = cannonicalAddr(addr);
        Record entry = (Record)table.get(addr);
        if (entry != null) {
            entry.activeContacts++;
        }
        else {
            //System.err.println("ContactCounter.incActive -- unknown addr: " + addr);
        }
    }

    public final synchronized void decActive(String addr) {
        addr = cannonicalAddr(addr);
        Record entry = (Record)table.get(addr);
        if (entry != null) {
            entry.activeContacts--;
        }
        else {
            //System.err.println("ContactCounter.decActive -- unknown addr: " + addr);
        }
    }

    public final synchronized Record[] getSnapshot() {
        Record[] ret = new Record[table.size()];
        int i = 0;
        Enumeration elements = table.elements();
        while (elements.hasMoreElements()) {
            // Deep copy because counts can be twiddled as
            // soon as we release the lock.
            ret[i++] = (Record) (((Record)elements.nextElement()).clone());
        }
        return ret;
    }

    public final synchronized int getTotal(String addr) {
        addr = cannonicalAddr(addr);
        Record entry = (Record)table.get(addr);
        if (entry == null) {
            return 0;
        }
        else {
            return entry.totalContacts;
        }
    }

    public final synchronized int getSuccesses(String addr) {
        addr = cannonicalAddr(addr);
        Record entry = (Record)table.get(addr);
        if (entry == null) {
            return 0;
        }
        else {
            return entry.successes;
        }
    }

    public final synchronized int getActive(String addr) {
        addr = cannonicalAddr(addr);
        Record entry = (Record)table.get(addr);
        if (entry == null) {
            return 0;
        }
        else {
            return entry.activeContacts;
        }
    }


    // can return host if IP lookup fails
    //    public final static String tryToGetIP(String host) {
    //        
    //        String ip = cannonicalAddr(host);
    //  // Strip transport prefix.
    //          if (ip.startsWith("tcp/") && ip.length() > 4) {
    //              ip = ip.substring(4);
    //          }
    
    //          try {
    //              ip = java.net.InetAddress.getByName(ip).getHostAddress();
    //          }
    //          catch (java.net.UnknownHostException uhe) {
    //              System.err.println("ContactCounter.tryToGetIP -- failed: " + ip);
    //          }
    // return ip.trim();
    //}

    private final static String cannonicalAddr(String addr) {
        int pos = addr.indexOf(":");
        if (pos > 0) {
            addr = addr.substring(0, pos);
        }

        return addr;
    }

    private Hashtable table = new Hashtable();
}

