package freenet.client.cli;

import freenet.message.client.FEC.SegmentHeader;
import freenet.client.*;
import freenet.client.events.*;
import freenet.support.Logger;

import java.io.PrintWriter;

/**
 * A SplitFileStatus subclass which dumps messages to
 * stdout for the CLI client implementation.
 * <p>
 * @author giannij
 */
public class CLISplitFileStatus extends SplitFileStatus {
    private Logger log;

    public CLISplitFileStatus(Logger log) {
        this.log = log;
    }

    public synchronized void dumpStatus() {
        if (header == null) {
            return;
        }

        int denom = header.getBlocksRequired();
        if (inserting) {
            denom = header.getBlockCount() + header.getCheckBlockCount();
        }
        else if (reinsertions > 0) {
            // Handles healing insertions while requesting.
            denom = reinsertions;
        }

        if ((statusCode == STARTING) ||
            (statusCode == ENCODING) ||
            (statusCode == DECODING)) {
            // No block stats
            log.log(this, statusString(statusCode) + " [" + (header.getSegmentNum() + 1) +
                        "/" + (header.getSegments()) + "]", log.NORMAL);
        }
        else if (statusCode == VERIFYING_CHECKSUM) {
            // Print out the checksum too
            log.log(this, statusString(statusCode) + " [" + (header.getSegmentNum() + 1) +
                        "/" + (header.getSegments()) + "]: " + checksum, log.NORMAL);
        }
        else {
            String fullStats = " (" + processed +  "/" + denom + "):[" + (header.getSegmentNum() + 1) +
                "/" + (header.getSegments()) + "] queued: " + queued +
                " running: " + running;
            log.log(this, statusString(statusCode) + fullStats, log.NORMAL);
        }

    }

    public synchronized void receive(ClientEvent ce) {
        if (!(ce instanceof SplitFileEvent)) {
            return;
        }
        super.receive(ce);
        switch (ce.getCode()) {
        case SegmentRequestStartedEvent.code: 
            // Will get a SegmentEncodingEvent immediately after.
            //case SegmentInsertStartedEvent.code: 
        case BlockFinishedEvent.code: 
        case SegmentDecodingEvent.code:
        case SegmentEncodingEvent.code:
        case SegmentHealingStartedEvent.code:
        case VerifyingChecksumEvent.code:
            dumpStatus();
            break;
        default: 
            // NOP
        }
    }
}





