package freenet.fs.tests;
import freenet.fs.dir.*;
import freenet.fs.*;
import freenet.crypt.*;
import java.io.*;

import freenet.support.test.SimpleTestRunner;
import junit.framework.TestCase;

public class DirectoryTest extends TestCase {

    public static void main(String[] args) throws IOException {
        SimpleTestRunner.main(new String[] {DirectoryTest.class.getName()});
    }

    Storage storage;
    FileSystem fs;
    Directory dir;
    LossyDirectory dsDir;

    public DirectoryTest(String name) {
        super(name);
    }

    public void setUp() {
        try {
            storage = new RAMStorage(500 * 1024);
            fs = new FileSystem(storage);
            fs.initialize(new Yarrow(), new Object());
            dir = new FSDirectory(fs, new SHA1(), 10000, 10000, 1000, 100);
            dsDir = new LossyDirectory(0x0001, dir);
        } catch (IOException e){
            fail(e.toString());
        }
    }

    public void testCircularBufferNoDelay() throws Throwable {
        runCircularBuffer(0);
    }

    public void testCircularBufferReadDelay() throws Throwable {
        runCircularBuffer(1);
    }

    public void testCircularBufferWriteDelay() throws Throwable {
        runCircularBuffer(2);
    }

    public void runCircularBuffer(int delayMode) throws Throwable {
        Buffer cb = new CircularBuffer(dsDir.forceStore(100, 
                                                        new FileNumber("abcabcabc")),
                                       499);
        
        OutputStream out = cb.getOutputStream();
        InputStream in = cb.getInputStream();
        
        WriteThread rt = new WriteThread(out, delayMode == 2);
        rt.start();
        
        int i;
        int pos = 0;
        while ((i = in.read()) != -1) {
            pos++;
            assertEquals(pos & 0xff, i);
            if (delayMode == 1)
                try {
                    Thread.sleep(1);
                } catch (InterruptedException e) {}
        }

        synchronized (rt) {
            while (!rt.done)
                try {
                    rt.wait(200);
                } catch (InterruptedException e) {
                }
            if (rt.t != null)
                throw rt.t;
        }
    }

    public static class WriteThread extends Thread {

        boolean done = false;
        Throwable t = null;

        OutputStream out;
        boolean delay;

        public WriteThread(OutputStream out, boolean delay) {
            this.out = out;
            this.delay = delay;
        }

        public void run() {
            try {
                for (int i = 1 ; i <= 499; i++) {
                    out.write(i & 0xff);
                    if (delay)
                        try {
                            Thread.sleep(1);
                        } catch (InterruptedException ie) {}
                }
            } catch (Throwable t) {
                this.t = t;
            } finally {
                synchronized(this) {
                    done = true;
                    notifyAll();
                }

            }
        }

    }




}
