package freenet.message.client;

import freenet.*;
import freenet.node.Node;
import freenet.client.FreenetURI;
import java.io.InputStream;
import java.net.MalformedURLException;

/** Superclass of FCP ClientGet and ClientPut messages.
  * @author tavin
  */
public abstract class ClientRequest extends ClientMessage {

    protected FreenetURI uri;
    protected final int hopsToLive;
    protected boolean RemoveLocal;

    public ClientRequest(ConnectionHandler source, RawMessage raw) {
        this(source, raw, false);
    }
    
    public ClientRequest(ConnectionHandler source, RawMessage raw, boolean getData) {
        super(source, raw, getData);
        int htl = -1;
        RemoveLocal = false;
        try {
            uri = new FreenetURI(otherFields.get("URI"));
            otherFields.remove("URI");
            htl = Integer.parseInt(otherFields.get("HopsToLive"), 16);
	    htl = Node.perturbHTL(htl);
            otherFields.remove("HopsToLive");
            if (otherFields.containsKey("Flags")) {
		int flags=Integer.parseInt(otherFields.get("Flags"), 16);
		// *** DO NOT USE THIS! PERIOD! Use RemoveLocalKey=true
		// instead.
	        if ((flags&1)>0)
                    RemoveLocal = true;
                else
                    RemoveLocal = false;
            }
            if (otherFields.containsKey("RemoveLocalKey"))
                RemoveLocal = true;
        }
        catch (Exception e) {
            formatError = true;
        }
        
        if (htl < 0) formatError = true;
        else if (htl > Node.maxHopsToLive) htl = Node.maxHopsToLive;

        hopsToLive = htl;
    }
    
    public FreenetURI getURI() {
        return uri;
    }

    public int getHTL() {
        return hopsToLive;
    }
    
    public boolean getRemoveLocal() {
    	return RemoveLocal;
    }
}


