package freenet.message.client;

import freenet.*;
import freenet.node.State;
import freenet.node.states.FCP.*;
import java.io.InputStream;

/** FCP command to make a public key from a private one.
 * @author giannij
 */
public class InvertPrivateKey extends ClientMessage {

    public static final String messageName = "InvertPrivateKey";

    private String privateValue = null;

    public InvertPrivateKey(ConnectionHandler source, RawMessage raw) {
        super(source, raw, false);
        if (!formatError) {
            formatError = true;
            try {
                privateValue = otherFields.get("Private");
                if (privateValue != null) {
                    otherFields.remove("Private");
                    formatError = false;
                }
            }
            catch (Exception e) {
                // NOP, formatError == false
            }
        }
    }

    public State getInitialState() {
        return formatError
            ? (State) new NewIllegal(id, source, "Error parsing InvertPrivateKey message.")
            : (State) new NewInvertPrivateKey(id, source);
    }

    public String getMessageName() {
        return messageName;
    }

    public final String getPrivateValue() { return privateValue; }
}
