package freenet.node;

import freenet.*;
import freenet.crypt.*;
import freenet.config.*;
import freenet.support.*;
import freenet.support.io.*;
import freenet.fs.dir.Directory;
import freenet.node.ds.*;
import freenet.node.rt.*;
import freenet.presentation.FreenetProtocol;
import freenet.transport.*;
import freenet.session.*;
import freenet.diagnostics.*;
import freenet.thread.ThreadFactory;
import freenet.interfaces.Interface;
import freenet.node.states.maintenance.*;
import freenet.client.ClientFactory;
import freenet.client.InternalClient;
import freenet.client.FECTools;
import freenet.client.BackgroundInserter;
import java.util.*;
import java.net.*;
import java.io.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * This is a Wrapper object that contains the components of a Node in the
 * Adaptive Network.  It uses a Network object to communicate with other
 * Nodes in the Network.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 * @author <a href="mailto:blanu@uts.cc.utexas.edu">Brandon Wiley</a>
 */

public class Node extends Core {

    public static int maxConnDefault = 512;
    public static boolean isWin9X;
    public static boolean isWinCE;
    public static boolean isOSX;
    
    public static String sysName = System.getProperty("os.name");
    
    static {

        // internal defaults
        config.addOption("rtMaxRefs",           1, 50,  1300);   // 50 refs/node
        config.addOption("rtMaxNodes",          1, 50,   1301);  // to 50 nodes

        config.addOption("maxRoutingSteps",     1, 40,   1303);  // to 10 refs

        config.addOption("messageStoreSize",    1, 1000,   1350);  // 1000 live chains
        config.addOption("failureTableSize",    1, 1000,  1360); // 1000 failed keys
        config.addOption("failureTableTime",    1, 1800000l, 1361); // 30 min
	
	// ARK stuff
	config.addOption("minCP",               1, 0.01F,    1370);
	config.addOption("failuresLookupARK",   1, 10,       1371);
	config.addOption("minARKDelay",         1, 900*1000, 1372);
	config.addOption("maxARKThreadsFraction",  1, 0.1F,  1373);
	
        // network defaults
        config.addOption("routeConnectTimeout", 1, 10000, 1400);  // 10 sec
        config.addOption("maxHopsToLive",       1, 25,    1410);
	config.addOption("probIncHopsSinceReset", 1, 0.95F,1411);
	config.addOption("cacheProbPerHop",     1, 0.8F,  1412);
	config.addOption("minStoreFullPCache",  1, 0.9F,  1413);
	config.addOption("minRTFullPRef",       1, 0.3F,  1414);

        // network resource limiting options
        config.addOption("bandwidthLimit",       1, 0,      1200);
        config.addOption("inputBandwidthLimit",  1, 0,      1201);  // disabled
        config.addOption("outputBandwidthLimit", 1, 12*1024,1202);  // 12kB/sec, so it doesn't ruin 128kbps uplink which is unfortunately way too common
        config.addOption("averageBandwidthLimit",       1, 0, 1203);  // disabled
        config.addOption("averageInputBandwidthLimit",  1, 0,      1204);  // disabled
        config.addOption("averageOutputBandwidthLimit", 1, 0,      1205);  // disabled
	
	sysName = sysName.toLowerCase();
	if(sysName.startsWith("windows ce"))
	    isWinCE = true;
	else isWinCE = false;
	
	if(sysName.startsWith("windows 95") || sysName.startsWith("windows 98")
	   || (sysName.startsWith("windows") && 
	       (sysName.indexOf("millennium") != -1)) ||
	   (sysName.startsWith("windows me"))) {
	    // Detected Windows 9X
	    maxConnDefault = 25;
	    isWin9X = true;
	} else isWin9X = false;
	
	if(sysName.startsWith("Mac OS X")) {
	    maxConnDefault = 128;
	    isOSX = true;
	} else isOSX = false;
	
        config.addOption("maxNodeConnections",   1, maxConnDefault,     1225);
        // I'm deprecating these in favor of
	config.addOption("maxConnectionsPerMinute", 1, 60,  1226);
	config.addOption("maxConnectionsMinute", 1, 60000,  1227);
        // these, and increasing the default quite a bit while at it.
        config.addOption("maxRequestsPerInterval", 1, 300, 1228);
        config.addOption("maxRequestsInterval", 1, 60000, 1229);
        // data store settings
        config.addOption("storeType",        1, "freenet",     999);  // "freenet" or "native"
        config.addOption("nodeFile",         1, "",            1000);  // node_<port>
        config.addOption("storeFile",        1, "",            1001);  // store_<port>
        config.addOption("storeSize",        1, "256M", 1010, true);  // 256MB is reasonable, strictish minimum would be 101MB ((1MB chunk + header) * 100)
	config.addOption("storeBlockSize",   1, 4096,          1011);
	config.addOption("storeMaxTempFraction", 1, (1F/3F),   1012);
        config.addOption("storeCipherName",  1, "Twofish",     1020);  // Twofish cipher
        config.addOption("storeCipherWidth", 1, 128,           1021);  // 128 bits
	config.addOption("routingDir",       1, "",            1022);
	config.addOption("useDSIndex",       1, true,          1023);
	
        
        // network settings
        config.addOption("ipAddress",  1, "",              100); // autodetected if not set
        config.addOption(new RandomPortOption("listenPort", 1, 101));  // random choice
        config.addOption("clientPort", 1, 8481,            110);
        config.addOption("fcpHosts",   1, "",              112);  // loopback only
        config.addOption("transient",  1, false,           300);
        config.addOption("seedFile",   1, "seednodes.ref", 320);
        
        // logging options
        config.addOption("logLevel",  1, "normal",      1250);     
        config.addOption("logFile",   1, "freenet.log", 1251);
        config.addOption("logFormat", 1, "d (c, t, p): m", 1252);
        config.addOption("logDate",   1, "",            1253);  // locale default
	config.addOption("logMaxLinesCached",1, 10000,  1254);
	config.addOption("logMaxBytesCached",1, "10M",  1255);
        
        // diagnostics options
        config.addOption("diagnosticsPath", 1, "stats", 501);
        
        // announcement options
        config.addOption("doAnnounce",            1, true,          310);
        config.addOption("announcementHTL",       1, 15,           1501);
        config.addOption("announcementAttempts",  1, 3,            1502);
	config.addOption("announcementPollInterval", 1, 900*1000,  1513);
	config.addOption("announcementFirstDelay", 1, 2*3600*1000, 1514);
	config.addOption("announcementThreads",   1, 3,            1515);
        config.addOption("announcementUseRT",     1, true,         1516);
        config.addOption("initialRequests",       1, 10,           1520);
        config.addOption("initialRequestHTL",     1, 25,           1521);
	
        // Load balancing
        config.addOption("doLoadBalance", 1, true,           1550);

	// wierd stuff
	config.addOption("localIsOK", 1, false,              1551);
	config.addOption("dontLimitClients", 1, false,       1552);
	config.addOption("limitAll", 1, false,               1553);
	config.addOption("mainportURIOverride", 1, "",       1554);
	config.addOption("distributionURIOverride", 1, "",   1555);
	config.addOption("aggressiveGC", 1, 15,              1556);
	config.addOption("configUpdateInterval", 1, 5,       1557);
	config.addOption("defaultToSimpleUIMode",  1, true,   1558);

	
        // FCP admin options
        config.addOption("adminPassword", 1, String.class, 200);
        config.addOption("adminPeer",     1, String.class, 201);
        
        config.addOption("logOutputBytes",  1, false,   3540);

	// Logging, overload, triage
        config.addOption("logInboundContacts",   1, false,   3500); 
        config.addOption("logOutboundContacts",  1, false,   3510); 
        config.addOption("logInboundRequests",  1, false,   3520); 
        config.addOption("logOutboundRequests",  1, false,   3530);
	config.addOption("logInboundInsertRequestDist",1,false,3541);
	config.addOption("logSuccessfulInsertRequestDist",1,false,3546);
	config.addOption("doRequestTriageByDelay", 1, true, 3251);
	config.addOption("overloadLow",1,0.85f,3252);
	config.addOption("overloadHigh",1,0.9f,3253);
	config.addOption("requestDelayCutoff",1,1000,3254);
	config.addOption("successfulDelayCutoff",1,2000,3255);
	config.addOption("defaultResetProbability",1, 0.05, 3556);
	
	// WatchMe options.
	config.addOption("watchme", 1, false, 3541);
        config.addOption("watchmeRetries", 1, 3, 3542);
	
	// Forward Error Correction (FEC) options
	config.addOption("FECTempDir", 1, "", 3600);
        config.addOption("FECInstanceCacheSize", 1, 1, 3610);
	config.addOption("FECMaxConcurrentCodecs", 1, 1, 3612);

        // Default FEC encoder and decoder implementations.
        config.addOption("FEC.Encoders.0.class", 1, "OnionFECEncoder", 3620);
        config.addOption("FEC.Decoders.0.class", 1, "OnionFECDecoder", 3630);
	
	// Default temp dir for FEC and fproxy if theirs aren't specified
	config.addOption("tempDir", 1, "", 3640);
	config.addOption("tempInStore", 1, false, 3641);
	
        config.addOption("publicNode", 1, false, 3650);

        // Allow HTTP inserts?
        config.addOption("httpInserts", 1, true, 3651);

        // Allow FCP inserts?
        config.addOption("fcpInserts", 1, true, 3652);
	
	// Bundled client stuff
	config.addOption("filterPassThroughMimeTypes", 1, "text/plain,image/jpeg,image/gif,image/png", 4000);
	
	// Mainport
	config.addOption("mainport.class", 1, "freenet.interfaces.servlet.MultipleHttpServletContainer", 4100);
	config.addOption("mainport.port", 1, 8888, 4101);
	config.addOption("mainport.allowedHosts", 1, "127.0.0.0/8", 4102);
	config.addOption("mainport.bindAddress", 1, "", 4103);
	
	config.addOption("mainport.params.servlet.1.uri", 1, "/", 4110);
	config.addOption("mainport.params.servlet.1.method", 1, "GET", 4111);
	config.addOption("mainport.params.servlet.1.class", 1, "freenet.client.http.FproxyServlet", 4112);
	config.addOption("mainport.params.servlet.1.name", 1, "Freenet HTTP proxy (fproxy)", 4113);
	config.addOption("mainport.params.servlet.1.params.requestHtl", 1, 15, 4114);
	config.addOption("mainport.params.servlet.1.params.passThroughMimeTypes", 1, "", 4115);
	config.addOption("mainport.params.servlet.1.params.filter", 1, true, 4116);
	config.addOption("mainport.params.servlet.1.params.filterParanoidStringCheck", 1, false, 4117);
	config.addOption("mainport.params.servlet.1.params.maxForceKeys", 1, 100, 4118);
	config.addOption("mainport.params.servlet.1.params.doSendRobots", 1, true, 4119);
	config.addOption("mainport.params.servlet.1.params.noCache", 1, false, 4119);
	
	config.addOption("mainport.params.servlet.2.uri", 1, "/servlet/nodeinfo/", 4120);
	config.addOption("mainport.params.servlet.2.method", 1, "GET", 4121);
	config.addOption("mainport.params.servlet.2.class", 1, "freenet.node.http.NodeInfoServlet", 4122);
	config.addOption("mainport.params.servlet.2.name", 1, "Web Interface", 4123);
	
        // default bookmarks. bookmarks start at 6000 so they come last in the config file
        config.addOption("mainport.params.servlet.2.bookmarks.count", 1, -1, 6000);
        
        config.addOption("mainport.params.servlet.2.bookmarks.0.key", 1, "SSK%40rBjVda8pC-Kq04jUurIAb8IzAGcPAgM/TFE//", 6100);
        config.addOption("mainport.params.servlet.2.bookmarks.0.title", 1, "The Freedom Engine", 6101);
        config.addOption("mainport.params.servlet.2.bookmarks.0.activelinkFile", 1, "ActiveLink.jpg", 6102);
        config.addOption("mainport.params.servlet.2.bookmarks.0.description", 1, "Oldest living Freenet portal", 6103);
        
        config.addOption("mainport.params.servlet.2.bookmarks.1.key", 1, "SSK@rjYFfgPHfolmcStiaoxESFfBXz8PAgM/FreenetHelp//", 6110);
        config.addOption("mainport.params.servlet.2.bookmarks.1.title", 1, "The Freenet Help Index", 6111);
        config.addOption("mainport.params.servlet.2.bookmarks.1.activelinkFile", 1, "ActiveLink.png", 6112);
        config.addOption("mainport.params.servlet.2.bookmarks.1.description", 1, "Index of Freenet help resources", 6113);
        
        config.addOption("mainport.params.servlet.2.bookmarks.2.key", 1, "SSK%40-w495UL3mfSlWC2c%7enRAuG2fAWwPAgM/TFEE//", 6120);
        config.addOption("mainport.params.servlet.2.bookmarks.2.title", 1, "The Tower (TFEE)", 6121);
        config.addOption("mainport.params.servlet.2.bookmarks.2.activelinkFile", 1, "activelink.png", 6122);
        config.addOption("mainport.params.servlet.2.bookmarks.2.description", 1, "Categorized automatically generated index with Google-like page ranking", 6123);

        config.addOption("mainport.params.servlet.2.bookmarks.3.key", 1, "SSK%409G4s~jLQJB7ALQg-v2q5xKAJy9YPAgM/CofE//", 6130);
        config.addOption("mainport.params.servlet.2.bookmarks.3.title", 1, "Content of Evil", 6131);
        config.addOption("mainport.params.servlet.2.bookmarks.3.activelinkFile", 1, "CofETitle.jpg", 6132);
        config.addOption("mainport.params.servlet.2.bookmarks.3.description", 1, "One of Freenet's oldest Freesites, witty discussion of Freenet, the universe, and everything", 6133);
        
        config.addOption("mainport.params.servlet.2.bookmarks.4.key", 1, "SSK%40Sc6qV~D6iFhaYord6HtbjJ8MaEYPAgM/YoYo//", 6140);
        config.addOption("mainport.params.servlet.2.bookmarks.4.title", 1, "YoYo!", 6141);
        config.addOption("mainport.params.servlet.2.bookmarks.4.activelinkFile", 1, "activelink.png", 6142);
        config.addOption("mainport.params.servlet.2.bookmarks.4.description", 1, "Categorized freenet index", 6143);
        
	config.addOption("mainport.params.servlet.3.uri", 1, "/servlet/images/", 4130);
	config.addOption("mainport.params.servlet.3.method", 1, "GET", 4131);
	config.addOption("mainport.params.servlet.3.class", 1, "freenet.client.http.ImageServlet", 4132);
	config.addOption("mainport.params.servlet.3.name", 1, "Server Images", 4133);

	config.addOption("mainport.params.servlet.4.uri", 1, "/servlet/Insert", 4140);
	config.addOption("mainport.params.servlet.4.method", 1, "BOTH", 4141);
	config.addOption("mainport.params.servlet.4.class", 1, "freenet.client.http.InsertServlet_", 4142);
	config.addOption("mainport.params.servlet.4.name", 1, "Insert Proxy Status", 4143);
	config.addOption("mainport.params.servlet.4.params.insertHtl", 1, 20, 4144);
	config.addOption("mainport.params.servlet.4.params.sfInsertThreads", 1, 30, 4145);
	config.addOption("mainport.params.servlet.4.params.sfInsertRetries", 1, 3, 4146);
	config.addOption("mainport.params.servlet.4.params.sfRefreshIntervalSecs", 1, 15, 4147);
	
	config.addOption("mainport.params.servlet.6.uri", 1, "/", 4190);
	config.addOption("mainport.params.servlet.6.method", 1, "POST", 4191);
	config.addOption("mainport.params.servlet.6.class", 1, "freenet.client.http.InsertServlet_", 4192);
	config.addOption("mainport.params.servlet.6.name", 1, "Insert Proxy", 4193);
	config.addOption("mainport.params.servlet.6.params.insertHtl", 1, 20, 4194);
	config.addOption("mainport.params.servlet.6.params.sfInsertThreads", 1, 20, 4195);
	config.addOption("mainport.params.servlet.6.params.sfInsertRetries", 1, 3, 4196);
	config.addOption("mainport.params.servlet.6.params.sfRefreshIntervalSecs", 1, 15, 4197);

	config.addOption("mainport.params.servlet.5.uri", 1, "/servlet/nodestatus/", 4150);
	config.addOption("mainport.params.servlet.5.method", 1, "BOTH", 4151);
	config.addOption("mainport.params.servlet.5.class", 1, "freenet.client.http.NodeStatusServlet", 4152);
	config.addOption("mainport.params.servlet.5.name", 1, "Node Status", 4153);
	


	config.addOption("mainport.params.servlet.7.uri", 1, "/servlet/SFRequest/", 4160);
	config.addOption("mainport.params.servlet.7.method", 1, "BOTH", 4161); // FIXME - it actually uses both?
	config.addOption("mainport.params.servlet.7.class", 1, "freenet.client.http.SplitFileRequestServlet", 4162);
	config.addOption("mainport.params.servlet.7.name", 1, "SplitFile Download Servlet (alpha!)", 4163);
	config.addOption("mainport.params.servlet.7.params.requestHtl", 1, 15, 4164);
	config.addOption("mainport.params.servlet.7.params.sfBlockRequestHtl", 1, 0, 4165);
	config.addOption("mainport.params.servlet.7.params.sfRequestRetries", 1, 4, 4166);
	config.addOption("mainport.params.servlet.7.params.sfRetryHtlIncrement", 1, 13, 4167);
	config.addOption("mainport.params.servlet.7.params.sfRequestThreads", 1, 30, 4168);
	config.addOption("mainport.params.servlet.7.params.sfDoParanoidChecks", 1, true, 4169);
	config.addOption("mainport.params.servlet.7.params.sfRefreshIntervalSecs", 1, 15, 4170);
	config.addOption("mainport.params.servlet.7.params.sfForceSave", 1, false, 4171);
	config.addOption("mainport.params.servlet.7.params.sfSkipDS", 1, false, 4172);
	config.addOption("mainport.params.servlet.7.params.sfUseUI", 1, true, 4173);
	config.addOption("mainport.params.servlet.7.params.sfRunFilter", 1, true, 4174);
	config.addOption("mainport.params.servlet.7.params.sfRandomSegs", 1, true, 4175);
	config.addOption("mainport.params.servlet.7.params.sfFilterParanoidStringCheck", 1, false, 4176);
	config.addOption("mainport.params.servlet.7.params.sfHealHtl", 1, 20, 4177);
	config.addOption("mainport.params.servlet.7.params.sfHealPercentage", 1, 100, 4178);
	config.addOption("mainport.params.servlet.7.params.sfForceSave", 1, true, 4179);
	
	String downloadDir;
	try {
	    downloadDir = System.getProperty("user.home") + File.separator +
		"freenet-downloads";
	} catch (Throwable e) {
	    downloadDir = "";
	}
	
	config.addOption("mainport.params.servlet.7.params.sfDefaultSaveDir", 1, 
			 downloadDir, 4180);
	config.addOption("mainport.params.servlet.7.params.sfDefaultWriteToDisk", 1, 
			 !downloadDir.equals(""), 4181);
	config.addOption("mainport.params.servlet.7.params.sfDisableWriteToDisk", 1,
			 false, 4182);
	config.addOption("mainport.params.servlet.8.uri", 1, "/servlet/stream/", 4190);
	config.addOption("mainport.params.servlet.8.method", 1, "GET", 4191);
	config.addOption("mainport.params.servlet.8.class", 1, "freenet.client.http.StreamServlet", 4192);
	config.addOption("mainport.params.servlet.8.name", 1, "Freenet Streaming Servlet", 4193);
	
	config.addOption("mainport.params.servlet.9.uri", 1, "/servlet/streamInsert/", 5101);
	config.addOption("mainport.params.servlet.9.method", 1, "GET", 5102);
	config.addOption("mainport.params.servlet.9.class", 1, "freenet.client.http.StreamInsertServlet", 5103);
	config.addOption("mainport.params.servlet.9.name", 1, "Freenet Stream Insert Servlet", 5104);
	
        config.setExpert("mainport.params.servlet.8.uri", true);
        config.setExpert("mainport.params.servlet.8.method", true);
        config.setExpert("mainport.params.servlet.8.class", true);
        config.setExpert("mainport.params.servlet.8.name", true);

        config.setExpert("mainport.params.servlet.9.uri", true);
        config.setExpert("mainport.params.servlet.9.method", true);
        config.setExpert("mainport.params.servlet.9.class", true);
        config.setExpert("mainport.params.servlet.9.name", true);
	
	config.addOption("mainport.params.defaultServlet.uri", 1, "/default", 4190);
	config.addOption("mainport.params.defaultServlet.method", 1, "GET", 4191);
	config.addOption("mainport.params.defaultServlet.class", 1, "freenet.client.http.RedirectServlet", 4192);
	config.addOption("mainport.params.defaultServlet.name", 1, "Web Interface Redirect", 4193);
	config.addOption("mainport.params.defaultServlet.params.targetURL", 1, "/servlet/nodeinfo/", 4194);
	
        // RouteConnectTimeout
        config.setExpert ("routeConnectTimeout", true);
        config.argDesc   ("routeConnectTimeout", "<millis>");
        config.shortDesc ("routeConnectTimeout", "wait on new connection when routing.");
        config.longDesc  ("routeConnectTimeout",
            "The time to wait for connections to be established and ",
            "authenticated before passing by a node while routing out.",
            "Connections that are by passed are still finished and cached ", 
            "for the time set by <connectionTimeout> (in milliseconds)."
        );

        // maxHopsToLive
        config.setExpert ("maxHopsToLive", true);
        config.argDesc   ("maxHopsToLive", "<integer>");
        config.shortDesc ("maxHopsToLive", "max HTL allowed on routed requests");
        config.longDesc  ("maxHopsToLive",
            "When forwarding a request, the node will reduce the HTL to this value",
            "if it is found to be in excess."                                       
        );

	// probIncHopsSinceReset
	config.setExpert ("probIncHopsSinceReset", true);
	config.argDesc   ("probIncHopsSinceReset", "<number between 0 and 1>");
	config.shortDesc ("probIncHopsSinceReset", "Probability of incrementing hopsSinceReset when forwarding a request. Leave this alone.");
	
	// cacheProbPerHop
	config.setExpert ("cacheProbPerHop", true);
	config.argDesc   ("cacheProbPerHop", "<number between 0 and 1>");
	config.longDesc  ("cacheProbPerHop", "Number which is raised to the power of the number of hops since a datasource reset to determine the cache probability. Set lower for better routing, higher for more caching/redundancy. The default is equivalent to approximately 5 nodes caching a file in a request.");
	
	// minStoreFullPCache
	config.setExpert ("minStoreFullPCache", true);
	config.argDesc   ("minStoreFullPCache", "<number between 0 and 1>");
	config.longDesc  ("minStoreFullPCache", "Minimum proportion of the datastore that must be filled before probabilistic caching kicks in.");
	
	// minRTFullPRef
	config.setExpert ("minRTFullPRef", true);
	config.argDesc   ("minRTFullPRef", "<number between 0 and 1>");
	config.longDesc  ("minRTFullPRef", "Minimium proportion of the routing table that must be filled before probabilistic referencing kicks in.");
	
        // nodeFile
        config.setExpert ("nodeFile", true);
        config.argDesc   ("nodeFile", "<file>");
        config.shortDesc ("nodeFile", "location of node's key file");
        config.longDesc  ("nodeFile",
            "The path to the file containing the node's private key, DSA group,",
            "cipher key, etc.  Defaults to node in the current directory."
        );
	
        // storeFile
        config.setExpert ("storeFile", true);
        config.argDesc   ("storeFile", "<file>[,..]");
        config.shortDesc ("storeFile", "location of data store directory - do not put anywhere with existing files");
        config.longDesc  ("storeFile",
			  "The path to the single directory containing the data "+
			  "store.  The total maximum size of the files in the "+
			  "directory is given by <storeSize>. It will create new "+
			  "files and directories in this dir, and DELETE OLD ONES. "+
			  "Defaults to store in the current directory.");
	
        // storeSize
        config.argDesc   ("storeSize", "<bytes - can use kKmMgGtTpPeE multipliers>");
        config.shortDesc ("storeSize", "size of the data store file(s)");
        config.longDesc  ("storeSize",
                          "The byte size of the data store directory.",
			  "The maximum sized file that will be cached is 1/100th of",
                          "this value.  We recommend the default 256MB, to cache the largest common",
                          "file size on freenet, 1MB plus some headers, with plenty of elbowroom, but",
                          "any size about 101MB should be adequate (a 1MB chunk is not exactly 1MB...).",
                          "Note that if you increase settings such as maxThreads, you may need to",
			  "use a larger store.");
	
	// storeType
	config.setExpert ("storeType", true);
	config.argDesc   ("storeType", "<string>");
	config.shortDesc ("storeType", "datastore implementation: \"native\" (new), \"monolithic\" (old, gets the DSB), \"freenet\" (autodetect, prefer native), or \"convert\" (convert old to new)");
	config.longDesc  ("storeType", "Datastore implementation. Put \"native\" (without the quotes) if you want the new native filesystem datastore, which stores the files in a directory. Put \"convert\" to convert from an old monolithic store to a native store. Note that convert uses lots of disk space while doing the conversion (approximately twice the datastore size), and the resulting store may be (temporarily) slightly larger than the old one due to block size mismatch (this will be fixed as soon as the node tries to add a file to the store).");
        
	// storeBlockSize
	config.setExpert ("storeBlockSize", true);
	config.argDesc   ("storeBlockSize", "<bytes>");
	config.shortDesc ("storeBlockSize", "Size of filesystem accounting blocks for storeType=native");
	config.longDesc  ("storeBlockSize", "Size of blocks in the underlying filesystem for purposes of calculating space usage when storeType=native.");
	
	// storeMaxTempFraction
	config.setExpert("storeMaxTempFraction", true);
	config.argDesc  ("storeMaxTempFraction", "<number between 0 and 1>");
	config.shortDesc("storeMaxTempFraction", "Maximum fraction of the datastore to use for temp files (assuming the temp dir is not overridden)");
	
        // storeCipherName
        config.setExpert ("storeCipherName", true);
        config.argDesc   ("storeCipherName", "<string>");
        config.shortDesc ("storeCipherName", "name of symmetric cipher algorithm");
        config.longDesc  ("storeCipherName", "deprecated");
        
        // storeCipherWidth
        config.setExpert ("storeCipherWidth", true);
        config.argDesc   ("storeCipherWidth", "<integer>");
        config.shortDesc ("storeCipherWidth", "bit-width of cipher key");
        config.longDesc  ("storeCipherWidth", "deprecated");

	// routingDir
	config.setExpert ("routingDir", true);
	config.argDesc   ("routingDir", "<directory>");
	config.shortDesc ("routingDir", "The directory in which to store the routing table files. Defaults to parent dir of storeDir");
	
	// useDSIndex
	config.setExpert ("useDSIndex", true);
	config.argDesc   ("useDSIndex", "true|false");
	config.shortDesc ("useDSIndex", "Use a datastore index file");
	config.longDesc  ("useDSIndex", "Use a datastore index file. Shorter startup time, but we have to run checkpoints, which lock the datastore, causing a hiccup");
	
        // rtMaxRefs
        config.setExpert ("rtMaxRefs", true);
        config.argDesc   ("rtMaxRefs", "<integer>");
        config.shortDesc ("rtMaxRefs", "max no. of refs per node");
        config.longDesc  ("rtMaxRefs",
            "The number of references allowed per node in the routing table.",
            "This should not be set too high."
        );
        
        // rtMaxNodes
        config.setExpert ("rtMaxNodes", true);
        config.argDesc   ("rtMaxNodes", "<integer>");
        config.shortDesc ("rtMaxNodes", "max no. unique nodes in routing table");
        config.longDesc  ("rtMaxNodes",
			  "The number of unique nodes that can be contained in the routing table.");
	
	// minCP
	config.setExpert ("minCP", true);
	config.argDesc   ("minCP", "<number between 0 and 1>");
	config.shortDesc ("minCP", "Lower bound on Contact Probability of nodes in the Routing Table");
	
	// failuresLookupARK
	config.setExpert ("failuresLookupARK", true);
	config.argDesc   ("failuresLookupARK", "<integer>");
	config.shortDesc ("failuresLookupARK", "Number of consecutive failures required to trigger an ARK lookup");
	
	// minARKDelay
	config.setExpert ("minARKDelay", true);
	config.argDesc   ("minARKDelay", "<milliseconds>");
	config.shortDesc ("minARKDelay", "Minimum time that a node in the routing table must have been uncontactable for before we can trigger an ARK lookup");
	
	// maxARKThreadsFraction
	config.setExpert ("maxARKThreadsFraction", true);
	config.argDesc   ("maxARKThreadsFraction", "<number between 0 and 1>");
	config.shortDesc ("maxARKThreadsFraction", "Maximum fraction of maxThreads to use for ARK lookups");
	
        // maxRoutingSteps
        config.setExpert ("maxRoutingSteps", true);
        config.argDesc   ("maxRoutingSteps", "<integer>");
        config.shortDesc ("maxRoutingSteps", "max no. node refs used per routing attempt.");
        config.longDesc  ("maxRoutingSteps",
            "The maximum number or node refs that will be used to route a request before RNFing."
        );

        
        // messageStoreSize
        config.setExpert ("messageStoreSize", true);
        config.argDesc   ("messageStoreSize", "<integer>");
        config.shortDesc ("messageStoreSize", "max no. of simultaneous requests.");
        config.longDesc  ("messageStoreSize",
            "The number of outstanding message replies the node will",
            "wait for before it starts to abandon them."              
        );

        // failureTableSize
        config.setExpert ("failureTableSize", true);
        config.argDesc   ("failureTableSize", "<integer>");
        config.shortDesc ("failureTableSize", "max. no. cached failed keys.");
        config.longDesc  ("failureTableSize",
             "The number keys that failed to be retrieved the node should key track of."
        );

        // failureTableTime
        config.setExpert ("failureTableTime", true);
        config.argDesc   ("failureTableTime", "<milliseconds>");
        config.shortDesc ("failureTableTime", "max. time to fail keys.");
        config.longDesc  ("failureTableTime",
             "The amount of time to keep keys cache keys that could not be found and",
             "automatically fail requests for them.");

        // bandwidthLimit
	config.setExpert ("bandwidthLimit", true); // because deprecated
        config.argDesc   ("bandwidthLimit", "<bytes/sec>");
        config.shortDesc ("bandwidthLimit", "DEPRECATED");
        config.longDesc  ("bandwidthLimit",
            "The maximum number of bytes per second to transmit, totaled between",
            "incoming and outgoing connections.  Ignored if either inputBandwidthLimit",
            "or outputBandwidthLimit is nonzero. DEPRECATED - please set inputBandwidthLimit and outputBandwidthLimit directly. Difficult to implement for NIO and not widely used."
        );
        
        // inputBandwidthLimit
        config.argDesc   ("inputBandwidthLimit", "<bytes/sec>");
        config.shortDesc ("inputBandwidthLimit", "incoming bandwidth limit");
        config.longDesc  ("inputBandwidthLimit",
			  "If nonzero, specifies an independent limit for incoming data only, in bytes per second. A 512kbps broadband (DSL or cable) connection is 32kB/sec, but you may want to use other things than Freenet on it. However, Freenet's background usage should be close to the output limit most of the time.");
        
        // outputBandwidthLimit
        config.argDesc   ("outputBandwidthLimit", "<bytes/sec>");
        config.shortDesc ("outputBandwidthLimit", "outgoing bandwidth limit");
        config.longDesc  ("outputBandwidthLimit",
			  "If nonzero, specifies an independent limit for outgoing data only. Not entirely accurate. If you need exact limiting, do it at the OS level. A typical broadband connection has either a 128kbps or a 256kbps uplink, this equates to 16kB/sec and 32kB/sec respectively. You will need to keep some bandwidth back for other apps and for downloads (yes, downloading uses a small amount of upload bandwidth). We suggest therefore limits of 12000 for a 128kbps upload connection, or 24000 for a 256kbps upload connection. Most broadband connections have far more download bandwidth than upload bandwidth... just because you have 1Mbps download, does not mean you have 1Mbps upload; if you do not know what your connection's upload speed is, use one of the above options.");
        
        // averageBandwidthLimit
	config.setExpert ("averageBandwidthLimit", true);
        config.argDesc   ("averageBandwidthLimit", "<bytes/sec>");
        config.shortDesc("averageBandwidthLimit", "DEPRECATED");
        config.longDesc  ("averageBandwidthLimit",
            "The maximum number of bytes per second to transmit (averaged over a week),",
            "totaled between incoming and outgoing connections.  Error to define it if",
            "any of (average)inputBandwidthLimit or (average)outputBandwidthLimit is",
	    "nonzero. DEPRECATED - please set inputBandwidthLimit and outputBandwidthLimit directly. Difficult to implement for NIO and not widely used.");
 
        // averageInputBandwidthLimit
        config.argDesc   ("averageInputBandwidthLimit", "<bytes/sec>");
        config.shortDesc("averageInputBandwidthLimit", "incoming bandwidth limit averaged over a week");
        config.longDesc  ("averageInputBandwidthLimit",
            "If nonzero, specifies an independent limit for incoming data only (averaged",
            "over a week).  (overrides averageBandwidthLimit if nonzero)");
 
        // averageOutputBandwidthLimit
        config.argDesc   ("averageOutputBandwidthLimit", "<bytes/sec>");
        config.shortDesc("averageOutputBandwidthLimit", "outgoing bandwidth limit averaged over a week");
        config.longDesc  ("averageOutputBandwidthLimit",
            "If nonzero, specifies an independent limit for outgoing data only (averaged",
            "over a week).  (overrides bandwidthLimit if nonzero)");

	// maxConnectionsPerMinute
	config.setExpert ("maxConnectionsPerMinute", true);
	config.argDesc	 ("maxConnectionsPerMinute", "<int>");
	config.shortDesc ("maxConnectionsPerMinute", "Max no. of connections in one minute.");
	config.longDesc  ("maxConnectionsPerMinute", "The maximum number of outgoing connections established in a one minute period. " 
                          + "Deprecated and ignored.");
	
	// maxConnectionsMinute
	config.setExpert ("maxConnectionsMinute", true);
	config.argDesc   ("maxConnectionsMinute", "<milliseconds>");
	config.shortDesc ("maxConnectionsMinute", "Length of a minute in milliseconds for purposes of maxConnectionsPerMinute");
	config.longDesc  ("maxConnectionsMinute", "The length of the period over which there must be at most maxConnectionsPerMinute connections. Deprecated"
                          + " and ignored.");


        // maxRequestsPerInterval
	config.setExpert ("maxRequestsPerInterval", true);
	config.argDesc	 ("maxRequestsPerInterval", "<int>");
        config.shortDesc ("maxRequestsPerInterval", "Max no. of connections per maxRequestsInterval.");
        config.longDesc  ("maxRequestsPerInterval", "The maximum number of outgoing connections established per maxRequestsInterval.");
	
	// maxRequestsInterval
	config.setExpert ("maxRequestsInterval", true);
	config.argDesc   ("maxRequestsInterval", "<milliseconds>");
        config.shortDesc ("maxRequestsInterval", "Length of the period in milliseconds for purposes of maxRequestsPerInterval");
        config.longDesc  ("maxRequestsInterval", "The length of the period over which there must be at most maxRequestsPerInterval connections.");

        // maxNodeConnections
        config.setExpert ("maxNodeConnections", true);
        config.argDesc   ("maxNodeConnections", "<int>");
        config.shortDesc ("maxNodeConnections", "Max. no. of connections to other "+
			  "nodes. Deprecated unless maximumThreads=0.");
        config.longDesc  ("maxNodeConnections", 
                          "The maximum number of incoming and outgoing connections to "+
			  "allow at the same time. Forced to 0.4*maximumThreads unless"+
			  " maximumThreads = 0.");
        
        // ipAddress
	config.setExpert ("ipAddress", true);
        config.argDesc   ("ipAddress", "xxx.xxx.xxx.xxx");
        config.shortDesc ("ipAddress", "your IP as seen by the public internet (normally this is autoconfigured)");
        config.longDesc  ("ipAddress",
			  "The IP address of this node as seen by the "+
			  "public Internet. You only need to override this "+
			  "if it cannot be autodetected, for example if you "+
			  "have a NAT (a.k.a. IP Masquerading) "+
			  "firewall/router, in which case you will need "+
			  "to set it to the IP address or DNS name of the "+
			  "internet-side interface of the router, which "+
			  "needs to be static (www.dyndns.org and similar "+
			  "services can help here if you have a dynamic IP).");

        // listenPort
        config.argDesc   ("listenPort", "<port no.>");
        config.shortDesc ("listenPort", "incoming FNP port");
        config.longDesc  ("listenPort",
            "The port to listen for incoming FNP (Freenet Node Protocol) connections on."
        );
        
        // clientPort
	config.setExpert ("clientPort", true);
        config.argDesc   ("clientPort", "<port no.>");
        config.shortDesc ("clientPort", "incoming FCP port");
        config.longDesc  ("clientPort",
            "The port to listen for local FCP (Freenet Client Protocol) connections on."
        );

        // fcpHosts
	config.setExpert ("fcpHosts", true);
        config.argDesc   ("fcpHosts", "<host list>");
        config.shortDesc ("fcpHosts", "hosts allowed to connect with FCP");
        config.longDesc  ("fcpHosts",
                          "A comma-separated list of hosts that may connect to the FCP port",
                          "(clientPort).  If left blank, only the localhost will be allowed." +
                          " If you set this, make sure localhost is included in the list or " +
                          " access won't be allowed from the local machine. ",
            "May be given as IP addresses or host names."
        );
        
        // logLevel
        config.argDesc   ("logLevel", "<word>");
        config.shortDesc ("logLevel", "error, normal, minor, or debug");
        config.longDesc  ("logLevel",
            "The error reporting threshold, one of:",
            "  Error:   Errors only",
            "  Normal:  Report significant events, and errors",
            "  Minor:   Report minor events, significant events, and errors",
	    "  Debug:   Report everything that can be reported"
        );
        
        // logFile
        config.setExpert ("logFile", true);
        config.argDesc   ("logFile", "<filename>|NO");
        config.shortDesc ("logFile", "path to the log file, or NO for STDERR");
        config.longDesc  ("logFile",
            "The name of the log file (`NO' to log to standard out)"
        );
        
        // logFormat
        config.setExpert ("logFormat", true);
        config.argDesc   ("logFormat", "<tmpl.>");
        config.shortDesc ("logFormat", "template, like d:c:h:t:p:m");
        config.longDesc  ("logFormat",
            "A template string for log messages.  All non-alphabet characters are",
            "reproduced verbatim.  Alphabet characters are substituted as follows:",
            "d = date (timestamp), c = class name of the source object,",
            "h = hashcode of the object, t = thread name, p = priority,",
            "m = the actual log message"
        );

        // logDate
        config.setExpert ("logDate", true);
        config.argDesc   ("logDate", "<tmpl.>");
        config.shortDesc ("logDate", "java style date/time template");
        config.longDesc  ("logDate",
            "A template for formatting the timestamp in log messages.  Defaults to",
            "the locale specific fully specified date format.  The template string",
            "is an ordinary Java date/time template - see:",
            "http://java.sun.com/products/jdk/1.1/docs/api/java.text.SimpleDateFormat.html"
        );
        
	// logMaxLinesCached
	config.setExpert ("logMaxLinesCached", true);
	config.argDesc   ("logMaxLinesCached", "<integer>");
	config.shortDesc ("logMaxLinesCached", "Maximum number of log lines to cache, anything above this will be discarded to prevent deadlocks and blocking");
	
	// logMaxBytes
	config.setExpert ("logMaxBytesCached", true);
	config.argDesc   ("logMaxBytesCached", "<bytes - can use kKmMgGg multipliers>");
	config.shortDesc ("logMaxBytesCached", "Maximum number of logged bytes to cache, anything above this will be discarded to prevent deadlocks and blocking");
	
        // seedFile
        config.argDesc   ("seedFile", "<file>");
        config.shortDesc ("seedFile", "initial node ref(s), for announcing");
        config.longDesc  ("seedFile",
            "A file containing one or more node references which will be incorporated",
            "into the node's routing table on startup.  A reference is only added if",
            "there is no previously existing reference to that node.  When this node",
            "announces, it will announce to the nodes listed in this file."
        );

        // doAnnounce
	config.setExpert ("doAnnounce", true);
        config.argDesc   ("doAnnounce", "yes|no");
        config.shortDesc ("doAnnounce", "whether to automatically announce");
        config.longDesc  ("doAnnounce",
            "If this is true, the node will automatically announce to all nodes in",
            "the <seedFile> file, as specified by <announcementDelay>, etc."
        );

        // announcementPeers
        config.setExpert ("announcementHTL", true);
        config.argDesc   ("announcementHTL", "<integer>");
        config.shortDesc ("announcementHTL", "no. of nodes announcement goes to");
        config.longDesc  ("announcementHTL",
            "The number of nodes that each announcement message should be" + 
                          "sent to."
                          );
        
        // announcementAttempts
        config.setExpert ("announcementAttempts", true);
        config.argDesc   ("announcementAttempts", "<integer>");
        config.shortDesc ("announcementAttempts", "number of attempts to announce");
        config.longDesc  ("announcementAttempts",
			  "The number of attempts to make at announcing this node "+
			  "in any given attempt for any given node . Zero means "+
			  "the node will not announce itself.");
	
	// announcementPollInterval
	config.setExpert ("announcementPollInterval",true);
	config.argDesc   ("announcementPollInterval", "<milliseconds>");
	config.shortDesc ("announcementPollInterval",
			  "Interval between polling for inactivity to reannounce");
	config.longDesc  ("announcementPollInterval",
                          "The time between polling for 1 hours no incoming requests to ",
            "force reannouncement.");
	
	// announcementFirstDelay
	config.setExpert ("announcementFirstDelay", true);
	config.argDesc   ("announcementFirstDelay", "<milliseconds>");
	config.shortDesc ("announcementFirstDelay", "Delay before announcing on first startup");
	
	// announcementThreads
	config.setExpert ("announcementThreads", true);
	config.argDesc   ("announcementThreads", "<integer>");
	config.shortDesc ("announcementThreads",
			  "Number of simultaneous announcement attempts");
	config.longDesc  ("announcementThreads",
			  "The number of simultaneous announcement attempts; when a" + 
			  "permanent node sees no traffic for a while, or when it" +  
			  "initially joins the network, it will try to announce to "+
			  "this many nodes.");
	
	
        // announcementUseRT
	config.setExpert ("announcementUseRT", true);
	config.argDesc   ("announcementUseRT", "yes|no");
	config.shortDesc ("announcementUseRT",
			  "announce to nodes from routing table?");
	config.longDesc  ("announcementThreads",
             "If we run out of seed nodes, we can use other nodes from the"+
             "routing table to announce to. However, since the trust level" +
             "of these nodes is unknown, this is not recommended for the" + 
             "truly paranoid.");

        // initialRequests
        config.setExpert ("initialRequests", true);
        config.argDesc   ("initialRequests","<integer>");
        config.shortDesc ("initialRequests", "number of initial requests");
        config.longDesc  ("initialRequests", 
             "The number of keys to request from the returned close values",
             "after an Announcement (this is per announcement made)."
        );

        // initialRequestHTL
        config.setExpert ("initialRequestHTL", true);
        config.argDesc   ("initialRequestHTL", "<integer>");
        config.shortDesc ("initialRequestHTL",
                          "HopsToLive on initial requests");
        config.longDesc  ("initialRequestHTL",
                          "The hops that initial requests should make.");

        //doLoadBalance
        config.setExpert ("doLoadBalance", true);
        config.argDesc   ("doLoadBalance", "yes|no");
        config.shortDesc ("doLoadBalance", "Use load balancing.");
        config.longDesc  ("doLoadBalance", 
                "Whether to emply load balancing algorithms against the ",
                "network.");

	//localIsOK
	config.setExpert ("localIsOK", true);
	config.argDesc   ("localIsOK", "yes|no");
	config.shortDesc ("localIsOK", "set yes to allow permanent nodes with non-internet-resolvable addresses. Do not use this except in a local testing network.");

	//dontLimitClients
	config.setExpert("dontLimitClients", true);
	config.argDesc  ("dontLimitClients", "yes|no");
	config.shortDesc("dontLimitClients", "set yes to not bandwidth throttle connections to LocalInterfaces i.e. FCP and mainport");
	
	//limitAll
	config.setExpert("limitAll", true);
	config.argDesc  ("limitAll", "yes|no");
	config.shortDesc("limitAll", "set yes to run the bandwidth limiter over all connections, local, network or internet. Overridden by dontLimitClients.");

	//mainportURIOverride
	config.setExpert("mainportURIOverride", true);
	config.argDesc  ("mainportURIOverride", "URI");
	config.shortDesc("mainportURIOverride", "URI to mainport servlet, e.g. for SSL tunneling");

	//distributionURIOverride
	config.setExpert("distributionURIOverride", true);
	config.argDesc  ("distributionURIOverride", "URI");
	config.shortDesc("distributionURIOverride", "URI to distribution servlet, e.g. for SSL tunneling");

	//aggressiveGC
	config.setExpert("aggressiveGC", true);
        config.argDesc  ("aggressiveGC", "<seconds>");
        config.shortDesc("aggressiveGC", "How often (in seconds) to do aggressive garbage collection. May impact performance but should reduce working set.  Set to 0 to disable.");

        //configUpdateInterval
        config.setExpert("configUpdateInterval", true);
        config.argDesc  ("configUpdateInterval", "<minutes>");
        config.shortDesc("configUpdateInterval", "How often (in minutes) to check for config file changes.  Set to 0 to disable.");
        
        

        // adminPassword
	config.setExpert ("adminPassword", true);
        config.argDesc   ("adminPassword", "<string>");
        config.shortDesc ("adminPassword", 
                          "allows remote admin using password.");
        config.longDesc  ("adminPassword",
               "If this is set then users that can provide the password can",
               "can have administrative access. It is recommended that",
               "you do not use this without also using adminPeer below",
               "in which case both are required.");

        // adminPeer
        config.setExpert ("adminPeer", true);
        config.argDesc   ("adminPeer","<Identity FieldSet>");
        config.shortDesc ("adminPeer",
                          "allows remote admin using PKI");
        config.longDesc  ("adminPeer",
              "If this is set, then users that are authenticated owners",
              "of the given PK identity can have administrative access.",
              "If adminPassword is also set both are required.");
          
        //defaultToSimpleUIMode
		config.setExpert ("defaultToSimpleUIMode", true);
		config.shortDesc ("defaultToSimpleUIMode", "Wheter the web interface should default to simple mode");
		config.longDesc  ("defaultToSimpleUIMode",
			 "The mainport and distribution servlets can display data in one out of two modes, Simple or Advanced. This parameter selects which of the two modes that should be the default mode."
		);

        // transient
        config.argDesc   ("transient", "yes|no");
        config.shortDesc ("transient", "a transient node is non-permanent");
        config.longDesc  ("transient",
            "Transient nodes do not give out references to themselves, and should",
            "therefore not receive any requests.  Set this to yes if you cannot",
            "receive incoming connections, or cannot keep the computer continuously",
            "online."
        );

        // diagnosticsPath
        config.setExpert ("diagnosticsPath", true);
        config.argDesc   ("diagnosticsPath", "<dir>");
        config.shortDesc ("diagnosticsPath", "directory to save statistics in");
        config.longDesc  ("diagnosticsPath",
            "The directory in which to save diagnostics data.  Defaults to",
            "<storePath>/stats if left blank."
        );

        /*
         * Class and port of the services are set as installation, because
         * the bad way that these are read requires them to be in the config.
         * That is dumb of course - a config file shouldn't even be necessary.
         * Hopefully I will fix that some day... -oskar
         */

        // NOTE: The default options for fproxy were moved into
        //       addDefaultHTTPPortParams. 20020922. --gj.
        //

        // Options for NodeStatusServlet.
        //config.addOption("nodestatus.class", 1, "freenet.client.http.NodeStatusServlet", 2040, true);
        //config.addOption("nodestatus.port", 1, 8889, 2041, true);

	// Options for distribution servlet
	config.addOption("distribution.class", 1, "freenet.node.http.DistributionServlet", 2100);
	config.addOption("distribution.port", 1, 8891, 2101);
	config.addOption("distribution.params.unpacked", 1, ".", 2102);
	config.addOption("distribution.params.distribDir", 1, "", 2105);
	config.addOption("distribution.allowedHosts", 1, "*", 2103);
	
        // Turn on fproxy, nodeinfo and NodeStatusServlet by default.

        // mainport is a MultipleHttpServletContainer instance which
        // runs fproxy and nodeinfo on the same port.
        config.addOption("services", 1, "mainport, distribution", 2011);

        config.addOption("mainport.params.servlet.10.uri", 1, "/servlet/bookmarkmanager", 7000);
        config.addOption("mainport.params.servlet.10.method", 1, "GET", 7001);
        config.addOption("mainport.params.servlet.10.class", 1, "freenet.node.http.BookmarkManagerServlet", 7002);
        config.addOption("mainport.params.servlet.10.name", 1, "Bookmark Manager Servlet", 7003);

        config.setExpert("mainport.params.servlet.10.uri", true);
        config.setExpert("mainport.params.servlet.10.method", true);
        config.setExpert("mainport.params.servlet.10.class", true);
        config.setExpert("mainport.params.servlet.10.name", true);

        // NodeStatusServlet class
        /*config.setExpert ("nodestatus.class", true);
        config.argDesc   ("nodestatus.class", "<class name>");
        config.shortDesc ("nodestatus.class", "NodeStatusServlet class");
        config.longDesc  ("nodestatus.class",
            "The Java class for the NodeStatusServlet. You shouldn't need to change this."
        );*/
        
        // NodeStatusServlet port
        /*config.setExpert ("nodestatus.port", true);
        config.argDesc   ("nodestatus.port", "<port number>");
        config.shortDesc ("nodestatus.port", "NodeStatusServlet listen port");
        config.longDesc  ("nodestatus.port",
            "The port that the node status servlet listens for HTTP requests on."
        );*/

        config.setExpert ("services", true);
        config.argDesc   ("services", "service_0,service_1,...");
        config.shortDesc ("services", "services run at start up");
        config.longDesc  ("services",
                          "A comma delimited list of services that are run when the node starts. " +
                          "If you don't know what this means, just accept the defaults."
        );
	
	// DistributionServlet class
	config.setExpert ("distribution.class", true);
	config.argDesc   ("distribution.class", "<class name>");
	config.shortDesc ("distribution.class", "Distribution servlet class");
	config.longDesc  ("distribution.class", "The Java class of the distribution servlet. You shouldn't need to touch this.");

	config.setExpert ("distribution.port", true);
	config.argDesc   ("distribution.port", "<port number>");
	config.shortDesc ("distribution.port", "DistributionServlet listen port");
	config.longDesc  ("distribution.port", "The port that the distribution servlet listens for HTTP requests on.");

	// distribution.params
	config.setExpert ("distribution.params.unpacked", true);
	config.argDesc   ("distribution.params.unpacked", "<directory>");
	config.shortDesc ("distribution.params.unpacked", 
			  "Dir where freenet was unpacked");
	config.longDesc  ("distribution.params.unpacked", "A directory containing (some of) the files needed for the Distribution Servlet - for example, a CVS tree, or where the UNIX tarball was unpacked.");
	
	// distribution.params.distribDir
	config.setExpert ("distribution.params.distribDir", true);
	config.argDesc   ("distribution.params.distribDir", "<directory>");
	config.shortDesc ("distribution.params.distribDir", "Dir to store redistributibles for the Distribution Servlet");
	config.longDesc  ("distribution.params.distribDir", "Directory used by the node to store redistributibles for the Distribution Servlet - there is rarely any need to override this.");

	// distribution.allowedHosts - whole internet by default
	config.setExpert ("distribution.allowedHosts", true);
	config.argDesc   ("distribution.allowedHosts", "<list of IP addresses>");
	config.shortDesc ("distribution.allowedHosts", "List of addresses that will be allowed to access distribution pages from the DistributionServlet");
	config.longDesc  ("distribution.allowedHosts", "These IP addresses will be allowed to access the distribution pages generated by the DistributionServlet. Default * means everyone.");
	
       	config.setExpert ("logOutputBytes",true);
        config.argDesc   ("logOutputBytes","true/false");
        config.shortDesc ("logOutputBytes",
                          "Set true to.count TCP bytes sent for diagnostics");
        
        config.setExpert("watchme",true);
        config.argDesc  ("watchme","true/false");
        config.shortDesc("watchme",
                         "Debugging only, setting this to true will remove your anonymity!");

        config.setExpert("watchmeRetries",true);
        config.argDesc  ("watchmeRetries","<integer>");
        config.shortDesc("watchmeRetries",
                         "Number of times watchMe will attempt to initialize");

        // FEC options
        config.setExpert("FECTempDir",true); // unnecessary
        config.argDesc  ("FECTempDir","<directory>");
        config.shortDesc("FECTempDir",
                         "Dir. used for FEC temp files. You don't need to set this.");

        config.setExpert("FEC.Encoders.0.class", true);
        config.argDesc  ("FEC.Encoders.0.class","<class name>");
        config.shortDesc("FEC.Encoders.0.class",
                         "Default FEC encoder implementation.");

        config.setExpert("FEC.Decoders.0.class", true);
        config.argDesc  ("FEC.Decoders.0.class","<class name>");
        config.shortDesc("FEC.Decoders.0.class",
                         "Default FEC decoder implementation.");

	// tempDir
	config.setExpert("tempDir", true);
	config.argDesc  ("tempDir", "<directory>");
	config.shortDesc("tempDir", "Dir used for temporary files, currently for fproxy");
	config.longDesc ("tempDir", "The directory used for temporary files. Used currently by fproxy and the FCP FEC mechanism, if their individual temp dirs are not set. If this is left unset, it will create a tempdir in the datastore (if the datastore is native).");
	
	// tempInStore
	config.setExpert("tempInStore", true);
	config.argDesc  ("tempInStore", "true/false");
	config.shortDesc("tempInStore", "Does temp space count as part of the datastore?");
	config.longDesc ("tempInStore", "If true, temp space counts as part of the datastore for space accounting purposes. This means that freenet will never use significantly more disk space than the configured storeSize (ignoring space used for log files and routing table files), but it also means that if you have a small store you may not be able to download large files.");
	
	// doRequestTriageByDelay
	config.setExpert ("doRequestTriageByDelay", true);
	config.argDesc   ("doRequestTriageByDelay", "true/false");
	config.shortDesc ("doRequestTriageByDelay", "triage requests if tickerDelay gets too high");
	config.longDesc  ("doRequestTriageByDelay", "If true, above 2000ms "+
			  "tickerDelay (successfulDelayCutoff) all incoming requests "+
			  "will be rejected, and above 1000ms, nearly all incoming "+
			  "requests will be rejected. This is an attempt to prevent "+
			  "the node from totally overwhelming the hardware it runs "+
			  "on, and slowing down the network in the process.");
	
	// overloadLow
	config.setExpert ("overloadLow", true);
	config.argDesc   ("overloadLow", "<float between 0 and 1>");
	config.shortDesc ("overloadLow", "start to selectively reject requests at this load");
	config.longDesc  ("overloadLow", "The node will start to selectively reject requests above this load level.");

	// overloadHigh
	config.setExpert ("overloadHigh", true);
	config.argDesc   ("overloadHigh", "<float between 0 and 1>");
	config.shortDesc ("overloadHigh", "reject all requests above this load");
	config.longDesc  ("overloadHigh", "The node will reject all QueryRequests above this load level.");
	
	// requestDelayCutoff
	config.setExpert ("requestDelayCutoff", true);
	config.argDesc   ("requestDelayCutoff", "<milliseconds>");
	config.shortDesc ("requestDelayCutoff", "reject queries above this routingTime");
	config.longDesc  ("requestDelayCutoff", "The node will reject nearly all incoming queries when routingTime is over this value.");

	// successfulDelayCutoff
	config.setExpert ("successfulDelayCutoff", true);
	config.argDesc   ("successfulDelayCutoff", "<milliseconds>");
	config.shortDesc ("successfulDelayCutoff", "reject all queries above this routingTime");
	config.longDesc  ("successfulDelayCutoff", "The node will reject ALL incoming queries above this routingTime.");
	
	// defaultResetProbability
	config.setExpert ("defaultResetProbability", true);
	config.argDesc   ("defaultResetProbability", "<probability>");
	config.shortDesc ("defaultResetProbability", "Default probability of resetting the DataSource");
	config.longDesc  ("defaultResetProbability", "The node will have this probability, on average (it varies according to load unless you set doLoadBalance=no), of resetting the datasource. Increase this to get more load, reduce it to get less load.");
	
        // logOutboundContacts
        config.setExpert ("logOutboundContacts",true);
        config.argDesc   ("logOutboundContacts","true/false");
        config.shortDesc ("logOutboundContacts",
                          "Set true to enable outbound contact monitoring.");
        
        // logInboundContacts
        config.setExpert ("logInboundContacts",true);
        config.argDesc   ("logInboundContacts","true/false");
        config.shortDesc ("logInboundContacts",
                          "Set true to enable inbound contact monitoring.");

        // logInboundRequests
        config.setExpert ("logInboundRequests",true);
        config.argDesc   ("logInboundRequests","true/false");
        config.shortDesc ("logInboundRequests",
                          "Set true to enable per host inbound request monitoring.");

        // logOutboundRequests
        config.setExpert ("logOutboundRequests",true);
        config.argDesc   ("logOutboundRequests","true/false");
        config.shortDesc ("logOutboundRequests",
                          "Set true to enable per host outbound request monitoring.");

        // logInboundInsertRequestDist
        config.setExpert ("logInboundInsertRequestDist",true);
        config.argDesc   ("logInboundInsertRequestDist","true/false");
        config.shortDesc ("logInboundInsertRequestDist",
                          "Set true to enable logging of inbound InsertRequest key distribution.");

	// logSuccessfulInsertRequestDist
	config.setExpert ("logSuccessfulInsertRequestDist", true);
	config.argDesc   ("logSuccessfulInsertRequestDist", "true/false");
	config.shortDesc ("logSuccessfulInsertRequestDist",
			  "Set true to enable logging of successful inbound InsertRequests' key distribution.");

	// FECInstanceCacheSize
	config.setExpert ("FECInstanceCacheSize", true);
	config.argDesc   ("FECInstanceCacheSize", "<integer>");
	config.shortDesc ("FECInstanceCacheSize", "Number of FEC instances to cache. Set to 1 unless you expect more than one simultaneous FEC operation.");
	
	// FECMaxConcurrentCodecs
	config.setExpert ("FECMaxConcurrentCodecs", true);
	config.argDesc   ("FECMaxConcurrentCodecs", "<integer>");
	config.shortDesc ("FECMaxConcurrentCodecs", "Number of concurrent FEC encodes/decodes allowed. " +
                          "Each codec can use up to 24Mb of memory." );
	
	// publicNode
        config.setExpert("publicNode",true);
        config.argDesc  ("publicNode","true/false");
        config.shortDesc("publicNode",
			 "Disables anonymity threatening servlets and infolets on a multi-user machine");

        // httpInserts
        config.setExpert ("httpInserts", true);
        config.argDesc   ("httpInserts", "true/false");
        config.shortDesc ("httpInserts", "Set false to disable inserts through FProxy.");

        // fcpInserts
        config.setExpert ("fcpInserts", true);
        config.argDesc   ("fcpInserts", "true/false");
        config.shortDesc ("fcpInserts", "Set false to disable FCP insertion.");
    
        // filterPassThroughMimeTypes
	config.setExpert("filterPassThroughMimeTypes", true /*?*/);
	config.argDesc  ("filterPassThroughMimeTypes", "comma delimited list of MIME types");
	config.shortDesc("filterPassThroughMimeTypes", "safe MIME types that will be passed through to the browser without query or filtering");


	// mainport.class
	config.setExpert("mainport.class", true);
	config.argDesc  ("mainport.class", "interface class");
	config.shortDesc("mainport.class", "Name of the interface class to run the mainport service. Leave it alone.");
	config.longDesc ("mainport.class", "Name of the interface class to run the mainport service. You do not need to change this.");
	
	// mainport.port
	config.setExpert("mainport.port", true);
	config.argDesc  ("mainport.port", "port number");
	config.shortDesc("mainport.port", "Port to run the main Freenet HTTP interface on");
	config.longDesc ("mainport.port", "Port to run the main Freenet HTTP interface on... this is the port that is accessed by your web browser when you are browsing freenet via fproxy, or looking at the various status monitors. This is normally only accessible from localhost, and is different from the public FNP port that other freenet nodes talk to, the FCP port that client programs talk to, and the distribution port that you can run a freenet distribution website on.");
	
	// mainport.allowedHosts
	config.setExpert("mainport.allowedHosts", true);
	config.argDesc  ("mainport.allowedHosts", "Comma delimited list of IP addresses, netmasks or hostnames");
	config.shortDesc("mainport.allowedHosts", "hosts allowed to access main freenet web interface");
	config.longDesc ("mainport.allowedHosts", "List of IP addresses (for example \"192.168.1.7\"), DNS names (\"erica\" or \"www.nsa.gov\") or netmasks (\"192.168.1.0/24\") of hosts (computers) that should be allowed to access the main web interface of your freenet node. Defaults to localhost (127.0.0.0/8) only.");
	
	// mainport.bindAddress
	config.setExpert("mainport.bindAddress", true);
	config.argDesc  ("mainport.bindAddress", "IP address or \"*\"");
	config.shortDesc("mainport.bindAddress", "IP address for main freenet web interface to listen on or \"*\"");
	config.longDesc ("mainport.bindAddress", "IP address of one interface for the main freenet web interface to listen on, or \"*\" to listen on all interfaces. Will be automatically determined from mainport.allowedHosts if not given; leave it alone.");
	
	// mainport.params.servlet.1.uri
	config.setExpert("mainport.params.servlet.1.uri", true);
	config.argDesc  ("mainport.params.servlet.1.uri", "path");
	config.shortDesc("mainport.params.servlet.1.uri", "Path within mainport for fproxy. Leave this alone");
	
	// mainport.params.servlet.1.method
	config.setExpert("mainport.params.servlet.1.method", true);
	config.argDesc  ("mainport.params.servlet.1.method", "HTTP method");
	config.shortDesc("mainport.params.servlet.1.method", "HTTP method for fproxy. Leave this alone.");
	
	// mainport.params.servlet.1.class
	config.setExpert("mainport.params.servlet.1.class", true);
        config.argDesc  ("mainport.params.servlet.1.class", "servlet class");
	config.shortDesc("mainport.params.servlet.1.class", "servlet class to run fproxy. Leave this alone.");
	
	// mainport.params.servlet.1.name
	config.setExpert("mainport.params.servlet.1.name", true);
	config.argDesc  ("mainport.params.servlet.1.name", "string");
	config.shortDesc("mainport.params.servlet.1.name", "name of first servlet on mainport (normally fproxy - \"Freenet HTTP proxy (fproxy)\"). Leave this alone.)");
	
	// mainport.params.servlet.1.params.requestHtl
	config.setExpert("mainport.params.servlet.1.params.requestHtl", true);
	config.argDesc  ("mainport.params.servlet.1.params.requestHtl", "integer HTL value between 0 and maxHopsToLive");
	config.shortDesc("mainport.params.servlet.1.params.requestHtl", "hops to live of fproxy requests");
	config.longDesc ("mainport.params.servlet.1.params.requestHtl", "hops to live (HTL) of requests made by fproxy");

	// mainport.params.servlet.1.params.passThroughMimeTypes
	config.setExpert("mainport.params.servlet.1.params.passThroughMimeTypes", true);
	config.argDesc  ("mainport.params.servlet.1.params.passThroughMimeTypes", "comma delimited list of MIME types");
	config.shortDesc("mainport.params.servlet.1.params.passThroughMimeTypes", "safe MIME types, defaults to filterPassThroughMimeTypes");
	config.longDesc ("mainport.params.servlet.1.params.passThroughMimeTypes", "MIME types regarded as safe that are passed to the browser without filtering or warning in fproxy. The default is empty (\"\"), which means to use the node global default filterPassThroughMimeTypes");
	
	// mainport.params.servlet.1.params.filter
	config.setExpert("mainport.params.servlet.1.params.filter", true);
	config.argDesc  ("mainport.params.servlet.1.params.filter", "true|false");
	config.shortDesc("mainport.params.servlet.1.params.filter", "run the anonymity filter on HTML/CSS");
	config.longDesc ("mainport.params.servlet.1.params.filter", "Whether to run the anonymity filter to remove HTML and CSS tags that might cause your browser to damage your anonymity");
	
	// mainport.params.servlet.1.params.filterParanoidStringCheck
	config.setExpert("mainport.params.servlet.1.params.filterParanoidStringCheck", true);
	config.argDesc  ("mainport.params.servlet.1.params.filterParanoidStringCheck", "true|false");
	config.shortDesc("mainport.params.servlet.1.params.filterParanoidStringCheck", "whether to make the anonymity filter really paranoid");
	config.longDesc ("mainport.params.servlet.1.params.filterParanoidStringCheck", "whether to make the anonymity filter really paranoid; currently this causes strings in CSS to be removed if they contain colons (\":\")");
	
	// mainport.params.servlet.1.params.maxForceKeys
	config.setExpert("mainport.params.servlet.1.params.maxForceKeys", true);
	config.argDesc  ("mainport.params.servlet.1.params.maxForceKeys", "integer");
	config.shortDesc("mainport.params.servlet.1.params.maxForceKeys", "Number of ?force= keys for fproxy to track");
	config.longDesc ("mainport.params.servlet.1.params.maxForceKeys", "Number of key overrides Fproxy should track... these are the confirmation pages you get when you go to some file that fproxy doesn't know how to handle");
	
	// mainport.params.servlet.1.params.doSendRobots
	config.setExpert("mainport.params.servlet.1.params.doSendRobots", true);
	config.argDesc  ("mainport.params.servlet.1.params.doSendRobots", "yes|no");
	config.shortDesc("mainport.params.servlet.1.params.doSendRobots", "Whether to send /robots.txt to the browser");
	
	// mainport.params.servlet.1.params.noCache
	config.setExpert("mainport.params.servlet.1.params.noCache", true);
	config.argDesc  ("mainport.params.servlet.1.params.noCache", "yes|no");
	config.shortDesc("mainport.params.servlet.1.params.noCache", "Whether to tell the browser not to cache Freenet content");
	
	// mainport.params.servlet.2.uri
	config.setExpert("mainport.params.servlet.2.uri", true);
	config.argDesc  ("mainport.params.servlet.2.uri", "path");
	config.shortDesc("mainport.params.servlet.2.uri", "Path within mainport for the Node Info Servlet");
	config.longDesc ("mainport.params.servlet.2.uri", "Path within mainport for the Node Info Servlet - this contains infolets which present pages of information about the node as well as the default front page");
	
	// mainport.params.servlet.2.method
	config.setExpert("mainport.params.servlet.2.method", true);
	config.argDesc  ("mainport.params.servlet.2.method", "HTTP method");
	config.shortDesc("mainport.params.servlet.2.method", "HTTP method for Node Info Servlet. Leave this alone.");
	
	// mainport.params.servlet.2.class
	config.setExpert("mainport.params.servlet.2.class", true);
	config.argDesc  ("mainport.params.servlet.2.class", "servlet class");
	config.shortDesc("mainport.params.servlet.2.class", "servlet class to run Node Info Servlet. Leave this alone");
	
	// mainport.params.servlet.2.name
	config.setExpert("mainport.params.servlet.2.name", true);
	config.argDesc  ("mainport.params.servlet.2.name", "string");
	config.shortDesc("mainport.params.servlet.2.name", "name of (usually) Node Info Servlet. Leave this alone.");
	
        // default bookmarks
        config.setExpert("mainport.params.servlet.2.bookmarks.count", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.count", "Number of bookmarks on fproxy");
        config.shortDesc("mainport.params.servlet.2.bookmarks.count", "Number of bookmarks on fproxy, or -1 to include all specified ones");
        
        config.setExpert("mainport.params.servlet.2.bookmarks.0.key", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.0.key", "freenet key");
        config.shortDesc("mainport.params.servlet.2.bookmarks.0.key", "The first bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.0.title", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.0.title", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.0.title", "The title for the first bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.0.activelinkFile", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.0.activelinkFile", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.0.activelinkFile", "The name of the activelink image within the key for the first bookmark");
        config.setExpert("mainport.params.servlet.2.bookmarks.0.description", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.0.description", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.0.description", "The description of the first bookmark on the web proxy");
        
        config.setExpert("mainport.params.servlet.2.bookmarks.1.key", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.1.key", "freenet key");
        config.shortDesc("mainport.params.servlet.2.bookmarks.1.key", "The second bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.1.title", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.1.title", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.1.title", "The title for the second bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.1.activelinkFile", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.1.activelinkFile", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.1.activelinkFile", "The name of the activelink image within the key for the second bookmark");
        config.setExpert("mainport.params.servlet.2.bookmarks.1.description", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.1.description", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.1.description", "The description of the second bookmark on the web proxy");
        
        config.setExpert("mainport.params.servlet.2.bookmarks.2.key", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.2.key", "freenet key");
        config.shortDesc("mainport.params.servlet.2.bookmarks.2.key", "The third bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.2.title", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.2.title", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.2.title", "The title for the third bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.2.activelinkFile", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.2.activelinkFile", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.2.activelinkFile", "The name of the activelink image within the key for the third bookmark");
        config.setExpert("mainport.params.servlet.2.bookmarks.2.description", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.2.description", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.2.description", "The description of the third bookmark on the web proxy");
        
        config.setExpert("mainport.params.servlet.2.bookmarks.3.key", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.3.key", "freenet key");
        config.shortDesc("mainport.params.servlet.2.bookmarks.3.key", "The fourth bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.3.title", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.3.title", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.3.title", "The title for the fourth bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.3.activelinkFile", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.3.activelinkFile", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.3.activelinkFile", "The name of the activelink image within the key for the fourth bookmark");
        config.setExpert("mainport.params.servlet.2.bookmarks.3.description", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.3.description", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.3.description", "The description of the fourth bookmark on the web proxy");
        
        config.setExpert("mainport.params.servlet.2.bookmarks.4.key", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.4.key", "freenet key");
        config.shortDesc("mainport.params.servlet.2.bookmarks.4.key", "The fifth bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.4.title", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.4.title", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.4.title", "The title for the fifth bookmark for the web proxy");
        config.setExpert("mainport.params.servlet.2.bookmarks.4.activelinkFile", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.4.activelinkFile", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.4.activelinkFile", "The name of the activelink image within the key for the fifth bookmark");
        config.setExpert("mainport.params.servlet.2.bookmarks.4.description", true);
        config.argDesc  ("mainport.params.servlet.2.bookmarks.4.description", "string");
        config.shortDesc("mainport.params.servlet.2.bookmarks.4.description", "The description of the fifth bookmark on the web proxy");
        
	// mainport.params.servlet.3.uri
	config.setExpert("mainport.params.servlet.3.uri", true);
	config.argDesc  ("mainport.params.servlet.3.uri", "path");
	config.shortDesc("mainport.params.servlet.3.uri", "Path within mainport for the Images Servlet");
	config.longDesc ("mainport.params.servlet.3.uri", "Path within mainport for the Images - this serves static images needed by fproxy and the Node Info Servlet");
	
	// mainport.params.servlet.3.method
	config.setExpert("mainport.params.servlet.3.method", true);
	config.argDesc  ("mainport.params.servlet.3.method", "HTTP method");
	config.shortDesc("mainport.params.servlet.3.method", "HTTP method for Images Servlet. Leave this alone.");
	
	// mainport.params.servlet.3.class
	config.setExpert("mainport.params.servlet.3.class", true);
	config.argDesc  ("mainport.params.servlet.3.class", "servlet class");
	config.shortDesc("mainport.params.servlet.3.class", "servlet class to run Images Servlet. Leave this alone");
	
	// mainport.params.servlet.3.name
	config.setExpert("mainport.params.servlet.3.name", true);
	config.argDesc  ("mainport.params.servlet.3.name", "string");
	config.shortDesc("mainport.params.servlet.3.name", "name of (usually) Images Servlet. Leave this alone.");
	
	// mainport.params.servlet.4.uri
	config.setExpert("mainport.params.servlet.4.uri", true);
	config.argDesc  ("mainport.params.servlet.4.uri", "path");
	config.shortDesc("mainport.params.servlet.4.uri", "Path within mainport for the Insert Servlet");
	config.longDesc ("mainport.params.servlet.4.uri", "Path within mainport for the Insert Servlet - used to insert files into freenet from the web interface");
	
	// mainport.params.servlet.4.method
	config.setExpert("mainport.params.servlet.4.method", true);
	config.argDesc  ("mainport.params.servlet.4.method", "HTTP method");
	config.shortDesc("mainport.params.servlet.4.method", "HTTP method for Insert "+
			 "Servlet (needs BOTH GET for status and PUT for uploads). "+
			 "Leave this alone.");
	
	// mainport.params.servlet.4.class
	config.setExpert("mainport.params.servlet.4.class", true);
	config.argDesc  ("mainport.params.servlet.4.class", "servlet class");
	config.shortDesc("mainport.params.servlet.4.class", "servlet class to run Insert Servlet. Leave this alone");
	
	// mainport.params.servlet.4.name
	config.setExpert("mainport.params.servlet.4.name", true);
	config.argDesc  ("mainport.params.servlet.4.name", "string");
	config.shortDesc("mainport.params.servlet.4.name", "name of (usually) Insert Servlet. Leave this alone.");
	
	// mainport.params.servlet.4.params.insertHtl
	config.setExpert("mainport.params.servlet.4.params.insertHtl", true);
	config.argDesc  ("mainport.params.servlet.4.params.insertHtl", "integer between 0 and maxHopsToLive");
	config.shortDesc("mainport.params.servlet.4.params.insertHtl", "hops to live (HTL) of inserts");
	config.longDesc ("mainport.params.servlet.4.params.insertHtl", "Hops-to-Live value (HTL) of inserts through the web interface");
	
	// mainport.params.servlet.4.params.sfInsertThreads
	config.setExpert("mainport.params.servlet.4.params.sfInsertThreads", true);
	config.argDesc  ("mainport.params.servlet.4.params.sfInsertThreads", "integer");
	config.shortDesc("mainport.params.servlet.4.params.sfInsertThreads", "threads to use to insert a splitfile");
	config.longDesc ("mainport.params.servlet.4.params.sfInsertThreads", "Number of threads to allocate to insert a splitfile through the web interface");

	// mainport.params.servlet.4.params.sfInsertRetries
	config.setExpert("mainport.params.servlet.4.params.sfInsertRetries", true);
	config.argDesc  ("mainport.params.servlet.4.params.sfInsertRetries", "integer");
	config.shortDesc("mainport.params.servlet.4.params.sfInsertRetries", "Number of retries if a block insert fails");
	
	// mainport.params.servlet.4.params.sfRefreshIntervalSecs
	config.setExpert("mainport.params.servlet.4.params.sfRefreshIntervalSecs", true);
	config.argDesc  ("mainport.params.servlet.4.params.sfRefreshIntervalSecs", "<seconds>");
	config.shortDesc("mainport.params.servlet.4.params.sfRefreshIntervalSecs", "How frequently to update insert status");
	
	// mainport.params.servlet.6.uri
	config.setExpert("mainport.params.servlet.6.uri", true);
	config.argDesc  ("mainport.params.servlet.6.uri", "path");
	config.shortDesc("mainport.params.servlet.6.uri", "Path within mainport for the Insert Servlet");
	config.longDesc ("mainport.params.servlet.6.uri", "Path within mainport for the Insert Servlet - used to insert files into freenet from the web interface");
	
	// mainport.params.servlet.6.method
	config.setExpert("mainport.params.servlet.6.method", true);
	config.argDesc  ("mainport.params.servlet.6.method", "HTTP method");
	config.shortDesc("mainport.params.servlet.6.method", "HTTP method for Insert Servlet (should be PUT). Leave this alone.");
	
	// mainport.params.servlet.6.class
	config.setExpert("mainport.params.servlet.6.class", true);
	config.argDesc  ("mainport.params.servlet.6.class", "servlet class");
	config.shortDesc("mainport.params.servlet.6.class", "servlet class to run Insert Servlet. Leave this alone");
	
	// mainport.params.servlet.6.name
	config.setExpert("mainport.params.servlet.6.name", true);
	config.argDesc  ("mainport.params.servlet.6.name", "string");
	config.shortDesc("mainport.params.servlet.6.name", "name of (usually) Insert Servlet. Leave this alone.");
	
	// mainport.params.servlet.6.params.insertHtl
	config.setExpert("mainport.params.servlet.6.params.insertHtl", true);
	config.argDesc  ("mainport.params.servlet.6.params.insertHtl", "integer between 0 and maxHopsToLive");
	config.shortDesc("mainport.params.servlet.6.params.insertHtl", "hops to live (HTL) of inserts");
	config.longDesc ("mainport.params.servlet.6.params.insertHtl", "Hops-to-Live value (HTL) of inserts through the web interface");
	
	// mainport.params.servlet.6.params.sfInsertThreads
	config.setExpert("mainport.params.servlet.6.params.sfInsertThreads", true);
	config.argDesc  ("mainport.params.servlet.6.params.sfInsertThreads", "integer");
	config.shortDesc("mainport.params.servlet.6.params.sfInsertThreads", "threads to use to insert a splitfile");
	config.longDesc ("mainport.params.servlet.6.params.sfInsertThreads", "Number of threads to allocate to insert a splitfile through the web interface");

	// mainport.params.servlet.6.params.sfInsertRetries
	config.setExpert("mainport.params.servlet.6.params.sfInsertRetries", true);
	config.argDesc  ("mainport.params.servlet.6.params.sfInsertRetries", "integer");
	config.shortDesc("mainport.params.servlet.6.params.sfInsertRetries", "Number of retries if a block insert fails");
	
	// mainport.params.servlet.6.params.sfRefreshIntervalSecs
	config.setExpert("mainport.params.servlet.6.params.sfRefreshIntervalSecs", true);
	config.argDesc  ("mainport.params.servlet.6.params.sfRefreshIntervalSecs", "<seconds>");
	config.shortDesc("mainport.params.servlet.6.params.sfRefreshIntervalSecs", "How frequently to update insert status");

	// mainport.params.servlet.5.uri
	config.setExpert("mainport.params.servlet.5.uri", true);
	config.argDesc  ("mainport.params.servlet.5.uri", "path");
	config.shortDesc("mainport.params.servlet.5.uri", "Path within mainport for the Node Status Servlet");
	config.longDesc ("mainport.params.servlet.5.uri", "Path within mainport for the Node Status Servlet - displays detailed information about node status. Disabled if publicNode is on.");
	
	// mainport.params.servlet.5.method
	config.setExpert("mainport.params.servlet.5.method", true);
	config.argDesc  ("mainport.params.servlet.5.method", "HTTP method");
	config.shortDesc("mainport.params.servlet.5.method", "HTTP method for Node Status Servlet. Leave this alone.");
	
	// mainport.params.servlet.5.class
	config.setExpert("mainport.params.servlet.5.class", true);
	config.argDesc  ("mainport.params.servlet.5.class", "servlet class");
	config.shortDesc("mainport.params.servlet.5.class", "servlet class to run Node Status Servlet. Leave this alone");
	
	// mainport.params.servlet.5.name
	config.setExpert("mainport.params.servlet.5.name", true);
	config.argDesc  ("mainport.params.servlet.5.name", "string");
	config.shortDesc("mainport.params.servlet.5.name", "name of (usually) Node Status Servlet. Leave this alone.");
	
	// mainport.params.servlet.7.uri
	config.setExpert("mainport.params.servlet.7.uri", true);
	config.argDesc  ("mainport.params.servlet.7.uri", "path");
	config.shortDesc("mainport.params.servlet.7.uri", "Path within mainport for the SplitFile Download Servlet");
	config.longDesc ("mainport.params.servlet.7.uri", "Path within mainport for the SplitFile Download Servlet - used to download large files through the web interface");
	
	// mainport.params.servlet.7.method
	config.setExpert("mainport.params.servlet.7.method", true);
	config.argDesc  ("mainport.params.servlet.7.method", "HTTP method");
	config.shortDesc("mainport.params.servlet.7.method", "HTTP method for SplitFile Download Servlet. Leave this alone.");
	
	// mainport.params.servlet.7.class
	config.setExpert("mainport.params.servlet.7.class", true);
	config.argDesc  ("mainport.params.servlet.7.class", "servlet class");
	config.shortDesc("mainport.params.servlet.7.class", "servlet class to run SplitFile Download Servlet. Leave this alone");
	
	// mainport.params.servlet.7.name
	config.setExpert("mainport.params.servlet.7.name", true);
	config.argDesc  ("mainport.params.servlet.7.name", "string");
	config.shortDesc("mainport.params.servlet.7.name", "name of (usually) SplitFile Download Servlet. Leave this alone.");
	
	// mainport.params.servlet.7.params.requestHtl
	config.setExpert("mainport.params.servlet.7.params.requestHtl", true);
	config.argDesc  ("mainport.params.servlet.7.params.requestHtl", "integer value between 0 and maxHopsToLive");
	config.shortDesc("mainport.params.servlet.7.params.requestHtl", "request HTL getting metadata in splitfile servlet");
	config.longDesc ("mainport.params.servlet.7.params.requestHtl", "Hops-To-Live of requests for the metadata of the splitfiles downloading splitfiles from the web interface.");
	
	// mainport.params.servlet.7.params.sfBlockRequestHtl
	config.setExpert("mainport.params.servlet.7.params.sfBlockRequestHtl", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfBlockRequestHtl", "integer value between 0 and maxHopsToLive");
	config.shortDesc("mainport.params.servlet.7.params.sfBlockRequestHtl", "initial request HTL for blocks in splitfile downloads");
	config.longDesc ("mainport.params.servlet.7.params.sfBlockRequestHtl", "initial Hops-To-Live (HTL) of requests for blocks downloading splitfiles");
	
	// mainport.params.servlet.7.params.sfRequestRetries
	config.setExpert("mainport.params.servlet.7.params.sfRequestRetries", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfRequestRetries", "positive integer");
	config.shortDesc("mainport.params.servlet.7.params.sfRequestRetries", "Number of retries on each block in a splitfile download");
	
	// mainport.params.servlet.7.params.sfRetryHtlIncrement
	config.setExpert("mainport.params.servlet.7.params.sfRetryHtlIncrement", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfRetryHtlIncrement", "positive integer");
	config.shortDesc("mainport.params.servlet.7.params.sfRetryHtlIncrement", "Amount to increase the HTL by on each retry");
	
	// mainport.params.servlet.7.params.sfRequestThreads
	config.setExpert("mainport.params.servlet.7.params.sfRequestThreads", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfRequestThreads", "positive integer");
	config.shortDesc("mainport.params.servlet.7.params.sfRequestThreads", "Number of threads to use to download a splitfile via the web interface");
	
	// mainport.params.servlet.7.params.sfDoParanoidChecks
	config.setExpert("mainport.params.servlet.7.params.sfDoParanoidChecks", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfDoParanoidChecks", "true|false");
	config.shortDesc("mainport.params.servlet.7.params.sfDoParanoidChecks", "Whether to run paranoid checks on blocks downloaded as part of a splitfile");
	
	// mainport.params.servlet.7.params.sfRefreshIntervalSecs
	config.setExpert("mainport.params.servlet.7.params.sfRefreshIntervalSecs", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfRefreshIntervalSecs", "<seconds>");
	config.shortDesc("mainport.params.servlet.7.params.sfRefreshIntervalSecs", "How frequently to update the splitfile user interface while downloading");
	
	// mainport.params.servlet.7.params.sfForceSave
	config.setExpert("mainport.params.servlet.7.params.sfForceSave", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfForceSave", "true|false");
	config.shortDesc("mainport.params.servlet.7.params.sfForceSave",  "Whether to (by default) force the browser to save splitfiles to disk");
	
	// mainport.params.servlet.7.params.sfSkipDS
	config.setExpert("mainport.params.servlet.7.params.sfSkipDS", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfSkipDS", "true|false");
	config.shortDesc("mainport.params.servlet.7.params.sfSkipDS", "Skip local datastore when downloading splitfiles?");
	config.longDesc ("mainport.params.servlet.7.params.sfSkipDS", "Whether to "+
			 "skip the local datastore when downloading splitfiles. "+
			 "If you don't know what this means you don't need it.");
	
	// mainport.params.servlet.7.params.sfUseUI
	config.setExpert("mainport.params.servlet.7.params.sfUseUI", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfUseUI", "true|false");
	config.shortDesc("mainport.params.servlet.7.params.sfUseUI", "Use downloader user interface when downloading files?");
	config.longDesc ("mainport.params.servlet.7.params.sfUseUI", "Whether to use the downloader user interface when downloading files. If set to no, files will be downloaded directly without showing any progress monitor, but this may take a very long time and most splitfiles do not send any data until the whole file has been downloaded");
	
	// mainport.params.servlet.7.params.sfRunFilter
	config.setExpert("mainport.params.servlet.7.params.sfRunFilter", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfRunFilter", "true|false");
	config.shortDesc("mainport.params.servlet.7.params.sfRunFilter", "Run the anonymity filter on HTML splitfiles?");
	
	// mainport.params.servlet.7.params.sfRandomSegs
	config.setExpert("mainport.params.servlet.7.params.sfRandomSegs", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfRandomSegs", "true|false");
	config.shortDesc("mainport.params.servlet.7.params.sfRandomSegs", "Randomize the order of segment downloads for splitfiles?");
	config.longDesc ("mainport.params.servlet.7.params.sfRandomSegs", "Whether to randomize the order of segment downloads for splitfiles. Normally this is a good thing.");
	
	// mainport.params.servlet.7.params.sfFilterParanoidStringCheck
	config.setExpert("mainport.params.servlet.7.params.sfFilterParanoidStringCheck", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfFilterParanoidStringCheck", "true|false");
	config.shortDesc("mainport.params.servlet.7.params.sfFilterParanoidStringCheck", "Make the anonymity filter on HTML splitfiles really paranoid?");
	config.longDesc ("mainport.params.servlet.7.params.sfFilterParanoidStringCheck", "Make the anonymity filter on HTML splitfiles really paranoid? Currently this causes strings in CSS to be removed if they contain colons (\":\")");
	
	// mainport.params.servlet.7.params.sfHealHtl
	config.setExpert("mainport.params.servlet.7.params.sfHealHtl", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfHealHtl", "integer between 0 and maxHopsToLive");
	config.shortDesc("mainport.params.servlet.7.params.sfHealHtl", "default HTL of splitfile healing insertions");
	config.longDesc ("mainport.params.servlet.7.params.sfHealHtl", "Default HTL of inserts caused by splitfile healing code");
	
	// mainport.params.servlet.7.params.sfHealPercentage
	config.setExpert("mainport.params.servlet.7.params.sfHealPercentage", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfHealPercentage", "0...100");
	config.shortDesc("mainport.params.servlet.7.params.sfHealPercentage", "Percentage of missing blocks to reinsert after fetching a redundant splitfile. Reinsertion is done in the background, so the default of 100 is quite reasonable.");
	
	// mainport.params.servlet.7.params.sfForceSave
	config.setExpert("mainport.params.servlet.7.params.sfForceSave", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfForceSave", "yes|no");
	config.shortDesc("mainport.params.servlet.7.params.sfForceSave", "force save splitfile downloads by default?");
	config.longDesc ("mainport.params.servlet.7.params.sfForceSave", "If true, large \"splitfiles\" will always be saved as application/octet-stream, to force the browser to save the file to disk rather than trying to open it in place.");
	
	// mainport.params.servlet.7.params.sfDefaultSaveDir
	config.setExpert("mainport.params.servlet.7.params.sfDefaultSaveDir", false);
	config.argDesc  ("mainport.params.servlet.7.params.sfDefaultSaveDir", "path to folder");
	config.shortDesc("mainport.params.servlet.7.params.sfDefaultSaveDir", "Default folder to save large downloaded files to. Defaults to a folder called \"freenet-downloads\" in your home directory.");
	
	// mainport.params.servlet.7.params.sfDefaultWriteToDisk
	config.setExpert("mainport.params.servlet.7.params.sfDefaultWriteToDisk", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfDefaultWriteToDisk", "yes|no");
	config.longDesc ("mainport.params.servlet.7.params.sfDefaultWriteToDisk", "Whether to write splitfiles to disk by default, rather than sending them to the browser");
	
	// mainport.params.servlet.7.params.sfDisableWriteToDisk
	config.setExpert("mainport.params.servlet.7.params.sfDisableWriteToDisk", true);
	config.argDesc  ("mainport.params.servlet.7.params.sfDisableWriteToDisk", "yes|no");
	config.longDesc ("mainport.params.servlet.7.params.sfDisableWriteToDisk", "Set true to disable the option to write splitfile downloads direct to disk rather than streaming them to the browser. Automatically enabled if publicNode is set.");
	
	// mainport.params.defaultServlet.uri
	config.setExpert("mainport.params.defaultServlet.uri", true);
	config.argDesc  ("mainport.params.defaultServlet.uri", "path");
	config.shortDesc("mainport.params.defaultServlet.uri", "Path within mainport for web interface redirect");
	config.longDesc ("mainport.params.defaultServlet.uri", "Path within mainport for web interface redirect");
	
	// mainport.params.defaultServlet.method
	config.setExpert("mainport.params.defaultServlet.method", true);
	config.argDesc  ("mainport.params.defaultServlet.method", "HTTP method");
	config.shortDesc("mainport.params.defaultServlet.method", "HTTP method for web interface redirect. Leave this alone.");
	
	// mainport.params.defaultServlet.class
	config.setExpert("mainport.params.defaultServlet.class", true);
	config.argDesc  ("mainport.params.defaultServlet.class", "servlet class");
	config.shortDesc("mainport.params.defaultServlet.class", "servlet class to run web interface redirect. Leave this alone");
	
	// mainport.params.defaultServlet.name
	config.setExpert("mainport.params.defaultServlet.name", true);
	config.argDesc  ("mainport.params.defaultServlet.name", "string");
	config.shortDesc("mainport.params.defaultServlet.name", "name of (usually) web interface redirect. Leave this alone.");
	
	// mainport.params.defaultServlet.params.targetURL
	config.setExpert("mainport.params.defaultServlet.params.targetURL", true);
	config.argDesc  ("mainport.params.defaultServlet.params.targetURL", "path");
	config.shortDesc("mainport.params.defaultServlet.params.targetURL", "path in the servlet to the default page");
	
    }
    
    //=== Static elements ======================================================
    
    // node specific options
    static public int routeConnectTimeout;
    static public int maxHopsToLive;
    static public float probIncHopsSinceReset;
    static public float cacheProbPerHop;
    static public float minStoreFullPCache;
    static public float minRTFullPRef;

    // announcement options
    static public int announcementAttempts;
    static public int announcementThreads;

    static public int initialRequests;
    static public int initialRequestHTL;
    static public float overloadLow;
    static public float overloadHigh;
    static public int requestDelayCutoff;
    static public int successfulDelayCutoff;
    static public double defaultResetProbability;

    static public boolean doLoadBalance;
    static public boolean localIsOK;
    static public boolean dontLimitClients;
    static public String mainportURIOverride;
    static public String distributionURIOverride;
    static public int aggressiveGC;
    static public int configUpdateInterval;
    static public boolean badAddress = false;

    // Negative values indicate a different threadfactory, but are normal
    static public int maxThreads;

    //static public int maxForwardTries;

    static public boolean firstTime = false;

    // node data files
    static public String nodeFile, storeFile[];

    // node limits
    static public long storeSize;
    static public int storeBlockSize;
    static public float storeMaxTempFraction;
    static public int rtMaxRefs, rtMaxNodes;
    static public int listenPort;
    static public String storeType;

    // The maximum number of node references that
    // will be returned by successive calls to
    // Routing.getNextRoute().
    static public int maxRoutingSteps;
    
    static public float minCP;
    static public int minARKDelay;
    static public int failuresLookupARK;
    static public float maxARKThreadsFraction;
    
    // datastore encryption
    static public String storeCipherName;
    static public int storeCipherWidth;
    
    static public File routingDir;
    static public boolean useDSIndex;
    
    // So we can keep track of how long the
    // node has been running. Approximate, but good enough.
    static final public long startupTimeMs = System.currentTimeMillis();

    // remote admin stuff
    static private String adminPassword;
    static private Identity adminPeer;

    // common service ports
    static public int distributionPort;
    static public int fproxyPort;

    // thread management
    static protected ThreadFactory threadFactory;

    // Number of outbound requests per minute the node will make.
    static public LimitCounter outboundRequestLimit;
    
    // client stuff
    static public String filterPassThroughMimeTypes;
    static public boolean httpInserts;
    static public boolean fcpInserts;
    
    static public Bandwidth ibw, obw;
    static public boolean defaultToSimpleUIMode;
    

    public static boolean isAuthorized(Identity id, String p) {
        if ( adminPassword != null && !adminPassword.equals("") 
             && adminPeer != null) {
            return adminPassword.equals(p) && adminPeer.equals(id);
        } else if (adminPassword != null && !adminPassword.equals("")) {
            return adminPassword.equals(p);
        } else if (adminPeer != null) {
            return adminPeer.equals(id);
        } else { // no remote admin
            return false;
        }
    }

    
    /**
     * @throws CoreException  if initialization has already occurred
     */
    public static void init(Params params) throws CoreException {
        // Init the core settings
        Core.init(params);

        // set keytypes 
	try {
	    Key.addKeyType(freenet.keys.SVK.keyNumber, freenet.keys.SVK.class);
	    Key.addKeyType(freenet.keys.CHK.keyNumber, freenet.keys.CHK.class);
	} catch (KeyException e) {
	    String s = "Failed initializing Key classes: "+e;
	    logger.log(Node.class, s, e, Logger.ERROR);
	    System.err.println(s);
	    e.printStackTrace(System.err);
	    CoreException ce = new CoreException(s);
	    ce.initCause(e);
	    throw ce;
	}
        String[] keyTypes = params.getList("keyTypes");
        for (int i = 1; keyTypes != null && i < keyTypes.length ; i += 2) { 
            try {
                Key.addKeyType(Integer.parseInt(keyTypes[i-1]),
                               Class.forName(keyTypes[i]));
            } catch (ClassNotFoundException e) {
                Core.logger.log(Node.class,"No such class: " + keyTypes[i] +
                                " for Key type " + keyTypes[i-1],Logger.ERROR);
            } catch (ClassCastException e) {
                Core.logger.log(Node.class, 
                                "Class " + keyTypes[i] + " is not a Key",
                                Logger.ERROR);
            } catch (KeyException e) {
		String s = "Failed initializing Key classes: "+e;
		logger.log(Node.class, s, e, Logger.ERROR);
		System.err.println(s);
		e.printStackTrace(System.err);
		CoreException ce = new CoreException(s);
		ce.initCause(e);
		throw ce;
	    }
        }
	
        // set network parameters
        routeConnectTimeout = params.getInt("routeConnectTimeout");
        maxHopsToLive = params.getInt("maxHopsToLive");
	probIncHopsSinceReset = params.getFloat("probIncHopsSinceReset");
	cacheProbPerHop = params.getFloat("cacheProbPerHop");
	minStoreFullPCache = params.getFloat("minStoreFullPCache");
	minRTFullPRef = params.getFloat("minRTFullPRef");
        announcementAttempts = params.getInt("announcementAttempts");
	announcementThreads = params.getInt("announcementThreads");
        initialRequests = params.getInt("initialRequests");
        initialRequestHTL = params.getInt("initialRequestHTL");
        //maxForwardTries    = Defaults.getInt("maxForwardTries", params);
	outboundRequestLimit = new LimitCounter(
                        params.getInt("maxRequestsInterval"), 
			params.getInt("maxRequestsPerInterval"));

        int bandwidthLimit, inputBandwidthLimit, outputBandwidthLimit;
        bandwidthLimit       = params.getInt("bandwidthLimit");
        inputBandwidthLimit  = params.getInt("inputBandwidthLimit") * 2 / 3;
        outputBandwidthLimit = params.getInt("outputBandwidthLimit") * 2 / 3;
        int averageBandwidthLimit, averageInputBandwidthLimit, averageOutputBandwidthLimit;
        averageBandwidthLimit       = params.getInt("averageBandwidthLimit");
        averageInputBandwidthLimit  = params.getInt("averageInputBandwidthLimit");
        averageOutputBandwidthLimit = params.getInt("averageOutputBandwidthLimit");
	
        if (inputBandwidthLimit == 0 && outputBandwidthLimit == 0 && averageInputBandwidthLimit==0 && averageOutputBandwidthLimit==0) {
	    if(bandwidthLimit != 0 || averageBandwidthLimit != 0) {
		String err = "Overall bandwidth limit NO LONGER SUPPORTED! - approximating by setting each direction to half the specified limit";
		Core.logger.log(Node.class, err, Logger.ERROR);
		System.err.println(err);
		System.out.println(err);
		
		ibw = new Bandwidth(bandwidthLimit/2, averageBandwidthLimit/2,
				    Bandwidth.RECEIVED);
		obw = new Bandwidth(bandwidthLimit/2, averageBandwidthLimit/2,
				    Bandwidth.SENT);
	    }
        }
        else {
	    ibw= inputBandwidthLimit == 0 ? null : new Bandwidth(inputBandwidthLimit, averageInputBandwidthLimit, Bandwidth.RECEIVED);
            obw = outputBandwidthLimit == 0 ? null : new Bandwidth(outputBandwidthLimit, averageOutputBandwidthLimit, Bandwidth.SENT);
        }
	
	if(params.getBoolean("limitAll")) {
	    logger.log(Node.class, "Limiting all connections",
		       Logger.DEBUG);
	    tcpAddress.throttleAll = true;
	    tcpListener.throttleAll = true;
	}
	try{
		tcpConnection.setInputBandwidth(ibw);
		tcpConnection.setOutputBandwidth(obw);
    }catch(NoClassDefFoundError e){
		if(e.getMessage().indexOf("java/nio/channels/spi/AbstractInterruptibleChannel") != -1){
			String error = "Your Java installation is too old (insufficient NIO support). Please update it to 1.4.1 or later; you can do that at http://java.sun.com/ .";
			System.err.println(error);
			Core.logger.log(Node.class, error, Core.logger.ERROR);
			Main.loggerHook.close();
			System.exit(1);
		}else
			throw e;
    }
//         ThrottledInputStream.setThrottle(ibw);
//         ThrottledOutputStream.setThrottle(obw);

        // set storage parameters
        storeSize = params.getLong("storeSize");
	if(storeSize < (101L * (1<<20))) {
	    String error = "Store size insufficient to store 1MB chunks! Your datastore is so small that it will not be able to store 1MB chunks, the maximum size of a single data key that most tools insert. You will still be able to fetch them but your node will not be very useful to the network, and consequentially will not perform well. To eliminate this error increase your storeSize to at least 101M. It is currently "+storeSize+".";
	    System.err.println(error);
	    Core.logger.log(Node.class, error, Core.logger.ERROR);
	}
	storeBlockSize = params.getInt("storeBlockSize");
	storeMaxTempFraction = params.getFloat("storeMaxTempFraction");
        //maxFileSize = cacheSize / params.getInt("storeCacheCount");
        
        rtMaxRefs  = params.getInt("rtMaxRefs");
        rtMaxNodes = params.getInt("rtMaxNodes");
        maxRoutingSteps = params.getInt("maxRoutingSteps");
	
	minCP = params.getFloat("minCP");
	failuresLookupARK = params.getInt("failuresLookupARK");
	minARKDelay = params.getInt("minARKDelay");
	maxARKThreadsFraction = (float)params.getFloat("maxARKThreadsFraction");
	
        storeCipherName = params.getString("storeCipherName");
        if (storeCipherName.equals("none")
            || storeCipherName.equals("null")
            || storeCipherName.equals("void")) storeCipherName = null;
            
        storeCipherWidth = params.getInt("storeCipherWidth");

	routingDir = new File(params.getString("routingDir"));
	
	useDSIndex = params.getBoolean("useDSIndex");
	
        // get the listening port
        listenPort = params.getInt("listenPort");

        // locate the data files
        nodeFile = params.getString("nodeFile");
        if (nodeFile == null || nodeFile.equals("")) {
	    File f = new File("node_" + listenPort);
	    nodeFile = "node";
	    if(f.exists()) {
		if(!f.renameTo(new File(nodeFile))) {
		    Core.logger.log(Node.class, "Cannot rename "+f+
				    " to \"node\". This would be useful "+
				    " because then you could change the port "+
				    " without causing the node identity to"+
				    " disappear, taking with it all references to"+
				    " your node from the rest of the network.",
				    Core.logger.NORMAL);
		    nodeFile = "node_" + listenPort;
		}
	    }
	}
	
        storeFile = params.getList("storeFile");
        if (storeFile.length == 0 || storeFile[0] == null || storeFile[0].equals("")) {
            storeFile = new String[] { "store" };
	    File f = new File("store_" + listenPort);
	    if(f.exists()) {
		if(!f.renameTo(new File("store"))) {
		    Core.logger.log(Node.class, "Cannot rename "+f+
				    " to \"store\". This would be useful"+
				    " because then you could change the port"+
				    " without causing the datastore to"+
				    " disappear, causing a major disk space leak"+
				    " and a significant loss of performance.",
				    Core.logger.NORMAL);
		    storeFile = new String[] {"store_" + listenPort };
		} else {
		    File idx = new File("store", "index");
		    if(idx.exists()) idx.delete();
		    idx = new File("store", "index.old");
		    if(idx.exists()) idx.delete();
		}
	    }
	}
	
        // set admin permisions
	
        String pword = params.getString("adminPassword");
        if (!"".equals(pword))
            adminPassword = pword;
        
        FieldSet peer = params.getSet("adminPeer");
        if (peer != null) {
            adminPeer = new DSAIdentity(peer);
        }

        overloadLow = params.getFloat("overloadLow");
	overloadHigh = params.getFloat("overloadHigh");
	requestDelayCutoff = params.getInt("requestDelayCutoff");
	successfulDelayCutoff = params.getInt("successfulDelayCutoff");
	defaultResetProbability = params.getDouble("defaultResetProbability");
        //System.err.println("This happens first.");

        doLoadBalance = params.getBoolean("doLoadBalance");
	localIsOK = params.getBoolean("localIsOK");
	dontLimitClients = params.getBoolean("dontLimitClients");
	mainportURIOverride = params.getString("mainportURIOverride");
	distributionURIOverride = params.getString("distributionURIOverride");
        aggressiveGC = params.getInt("aggressiveGC");
        configUpdateInterval = params.getInt("configUpdateInterval");

	distributionPort = params.getInt("distribution.port");
	fproxyPort = params.getInt("mainport.port"); // FIXME
	filterPassThroughMimeTypes = params.getString("filterPassThroughMimeTypes");
        httpInserts = params.getBoolean("httpInserts");
        fcpInserts = params.getBoolean("fcpInserts");
	defaultToSimpleUIMode = params.getBoolean("defaultToSimpleUIMode");
    }
    

    /**
     * Construct this node's NodeReference from the given private key.
     */
    static NodeReference makeNodeRef(Authentity priv, Address[] addr,
                                     SessionHandler sh, 
				     PresentationHandler ph, long ARKversion,
				     byte[] ARKcrypt) {
        long[] sessions, presentations;
        Enumeration e;

        sessions = new long[sh.size()];
        e = sh.getLinkManagers();
        for (int i=0; i<sessions.length; ++i)
            sessions[i] = ((LinkManager) e.nextElement()).designatorNum();

        presentations = new long[ph.size()];
        e = ph.getPresentations();
        for (int i=0; i<presentations.length; ++i)
            presentations[i] = ((Presentation) e.nextElement()).designatorNum();
    
        NodeReference nr = new NodeReference(priv.getIdentity(), addr,
                                             sessions, presentations,
                                             Version.getVersionString(), 
					     ARKversion, ARKcrypt);
	
        // FIXME - this method should accept an uncast Authentity
        nr.addSignature((DSAAuthentity) priv);

        return nr;
    }


    /**
     * The Directory that stores all the node's data.
     */
    public final Directory dir;

    /**
     * A source of temp file buckets.
     */
    public final BucketFactory bf;

    /**
     * The nodes table of cached documents.
     */    
    public final DataStore ds;

    /**
     * The routing table for routing requests on a key.
     */
    public final RoutingTable rt;

    /**
     * The table of recently failed keys.
     */
    public final FailureTable ft;

    /**
     * Load statistics module.
     */ 
    public final LoadStats loadStats;

    /**
     * Support for FEC encoding / FEC decoding.
     **/
    public static FECTools fecTools = null;

    // REDFLAG: initialize, better interface, i.e make final?
    
    /**
     * Temp dir for servlets, FEC etc
     */
    public static File tempDir = null;

    // REDFLAG: initialize, better interface, i.e make final?
    
    /**
     * A node reference to this node. Basically this is who the node is
     * to the network.
     */
    public NodeReference myRef;
    // FIXME: make protected, use an accessor
    // Only the update-ARK code needs to modify myRef

    public final NodeReference getNodeReference() {
        return myRef;
    }


    private final boolean isTransient;
    
    /** @return  true if this is a transient node */
    public final boolean isTransient() {
        return isTransient;
    }

    
    /**
     * Internal client access.
     */
    public final ClientFactory client;

    
    /**
     * Creates a new Node.
     * @param privKey     The node's private key.
     * @param dir         Directory of the node's storage repository.
     * @param bf          The source for temp file buckets.
     * @param ds          The store where cached data is kept.
     * @param rt          The table for routing requests based on key values.
     * @param ft          The table that keeps track recently failed keys.
     * @param myRef       The NodeReference name to send to other 
     *                    nodes.
     * @param th          A transporthandler on which the available transports
     *                    are registered.
     * @param sh          The sessionhandler to use for making connections
     * @param ph          The presentationHandler to use for making connections
     * @param loadStats   The restored LoadStats object
     * @param isTransient whether this node is transient
     */
    public Node(Authentity privKey, NodeReference myRef,
                Directory dir, BucketFactory bf, DataStore ds, RoutingTable rt,
                FailureTable ft, TransportHandler th, SessionHandler sh,
                PresentationHandler ph, LoadStats loadStats, 
                boolean isTransient) {
        
        super(privKey, myRef.getIdentity(), th, sh, ph);
        this.myRef = myRef;
        this.dir = dir;
        this.bf = bf;
        this.ds = ds;
        this.ft = ft;
        this.rt = rt;
        this.client = new InternalClient(this);
        this.isTransient = isTransient;

        this.loadStats = loadStats;

        // Set up the background inserter.
        BackgroundInserter.setSharedInstance(new NodeBackgroundInserter(5, 128, client,bf));
        BackgroundInserter.getInstance().start();

        // Too early, must be done elsewhere....
        //new Checkpoint(loadStats).schedule(this);
    }

    protected class NodeBackgroundInserter extends BackgroundInserter {
	public NodeBackgroundInserter(int nThreads, int maxSize,
				      ClientFactory cf,
				      BucketFactory bf) {
	    super(nThreads, maxSize, cf, bf);
	}
	
	protected void onDone(boolean success, int htl, 
			      freenet.client.FreenetURI uri) {
	    super.onDone(success, htl, uri);
	    Core.logger.log(this, "Background healing insert: " + 
			    (success ? "Success: " : "Failure: ")
			    +((uri == null) ? "(null)" : uri.toString()),
			    Logger.DEBUG);
	    if(success)
		diagnostics.occurrenceCounting("successBackgroundInsert", 1);
	    else
		diagnostics.occurrenceCounting("failureBackgroundInsert", 1);
	}
	
	protected void logDebug(String s, boolean trace) {
	    if(Core.logger.shouldLog(Core.logger.DEBUG)) {
		if(trace)
		    Core.logger.log(this, s, Core.logger.DEBUG);
		else
		    Core.logger.log(this, s, new Exception("debug"),
				    Core.logger.DEBUG);
	    }
	}
	
	public synchronized void queue(Bucket block, BucketFactory owner, int htl, 
				       String cipher) {
	    super.queue(block, owner, htl, cipher);
	    if(logger.shouldLog(Core.logger.MINOR))
		logger.log(this, "Queued a background insert at HTL " + htl, 
			   Logger.MINOR);
	    diagnostics.occurrenceCounting("queuedBackgroundInsert", 1);
	}
	
	protected void onRawEvent(freenet.client.ClientEvent e) {
	    if(Core.logger.shouldLog(Core.logger.DEBUG)) {
		Core.logger.log(this, "BI: " + e.getDescription(), 
				Logger.DEBUG);
	    }
	}
	
	protected void onStart() {
	    if(Core.logger.shouldLog(Core.logger.MINOR)) {
		Core.logger.log(this, "BackgroundInserter -- thread started.",
				Core.logger.MINOR);
	    }
	}
	
	protected void onExit() {
	    if(Core.logger.shouldLog(Core.logger.MINOR)) {
		Core.logger.log(this, "BackgroundInserter -- thread exited.",
				Core.logger.MINOR);
	    }
	}
    }

    /** @return  something for the logs.. */
    public final String toString() {
        return "Freenet Node: " + Fields.bytesToHex(identity.fingerprint());
    }

    /**
     * Returns a peer object for which a connection with a node can be
     * made.
     * @param nr  The node for which a Peer object is needed.
     */
    public final Peer getPeer(NodeReference nr) {
        return nr.getPeer(transports, sessions, presentations);
    }

    /*
    public void begin(ThreadFactory tf, Ticker t,
                      OpenConnectionManager ocm, Interface[] inter,
                      boolean daemon) throws CoreException {
        
        super.begin(tf, t, ocm, inter, daemon);

        //(new StoreCheckpoint(randSource.nextLong(),
        //                     1000 * checkpointInterval)).schedule(this);
        //(new LinkCleanup(randSource.nextLong(),
        //                 1000 * 60 * 5, sessions)).schedule(this);

        schedule(15 * 1000, new DiagnosticsPeriod(randSource.nextLong()));
    }
    */

    /**
     * @return Number of jobs running or queued for execution by
     *         the node's ThreadManager. Can return -1 if no thread manager is
     *         being used.
     **/
    public final int activeJobs() {
        return threadFactory.activeThreads();
    }

    public final int availableThreads() {
        return threadFactory.availableThreads();
    }

    public ThreadFactory getThreadFactory() {
        return threadFactory;
    }

    /**
     * @return true if the Node is Rejecting inbound connections, false otherwise.
     **/
    public boolean rejectingConnections() {
        int maximumThreads = threadFactory.maximumThreads();
        return ((maximumThreads > 0) &&
            (threadFactory.activeThreads() >= maximumThreads));
    }


    /**
     * @return true if the Node is QueryRejecting inbound requests, false otherwise.
     **/
    public boolean rejectingRequests() {
        if (outboundRequestLimit.exceeded()) {
            return true;
        }

	return estimatedLoad() > overloadLow;
    }


    /**
     *  This is a rough estimate based on the number of running
     *  jobs. Hopefully we can come up with a better metric later.  
     *
     * @return a value between (0.0, 1.0), where 0.0 indicates
     *         no load and 1.0 indicates total overload.
     *
     **/
    public final float estimatedLoad() {
	double ret;

        int maximumThreads = threadFactory.maximumThreads();

	if (maximumThreads <= 0) 
	    ret = 0;
	else 
	    ret = (double)activeJobs() / (double)maximumThreads;
	
        if (diagnostics != null && Main.doRequestTriageByDelay) {
            double delay = diagnostics.getValue("routingTime",
						Diagnostics.MINUTE,
						Diagnostics.MEAN_VALUE);
            delay = overloadLow + 
		(1-overloadLow) * (delay - requestDelayCutoff) / 
		(successfulDelayCutoff - requestDelayCutoff);
            if (delay > overloadLow && ret < delay) ret = delay;
        }

        if (ret > 1.0f) {
            return 1.0f;
        }

        return (float)ret;
    }
 
    /**
     * Hook for rate limiting.
     */
    public boolean acceptRequest(Key searchKey, Address source) {

        String diagAddr = null;

        if (inboundRequests != null) {
            diagAddr = source.toString();
            inboundRequests.incTotal(diagAddr);
        }

	float load = estimatedLoad();

        if ((!outboundRequestLimit.exceeded())  &&
	    load < overloadLow) {
            if (inboundRequests != null) {
                inboundRequests.incSuccesses(diagAddr);
            }
            return true;
        }

	// Node is slightly overloaded
        if ((load < overloadHigh) &&
            (ft.contains(searchKey) || 
             ds.contains(searchKey))) {
	    if (inboundRequests != null) {
		inboundRequests.incSuccesses(diagAddr);
	    }
	    return true;
	}

        // Node is overloaded
        return false;
    }


    //=== communications methods ===============================================

    /**
     * Returns a connection that messages can be sent on. This saves a 
     * little time as getPeer is only called if a free connection isn't
     * available.
     * @param nr        The node to connect to.
     * @param timeout   The time to allow in connecting.
     */
    public ConnectionHandler makeConnection(NodeReference nr, long timeout) 
                                            throws CommunicationException {
        Peer p = getPeer(nr);
        if (p == null)
            throw new ConnectFailedException(new VoidAddress(), nr.getIdentity(),
                                             "Unusable node ref", true);
        return makeConnection(p, timeout);
    }

    public final ConnectionHandler makeConnection(NodeReference nr)
                                            throws CommunicationException {
        return makeConnection(nr, 0);
    }


    /**
     * Sends a message accross an open or new connection. This saves a 
     * little time as getPeer is only called if a free connection isn't
     * available.
     * @param nr        The node to connect to.
     * @param m         The message to send.
     * @param timeout   The time to allow in connecting.
     * @return  The trailing field stream (if there is one).
     */
    public final OutputStream sendMessage(Message m, NodeReference nr, long timeout) 
                                                    throws CommunicationException {
        return makeConnection(nr, timeout).sendMessage(m);
    }
    
    public final OutputStream sendMessage(Message m, NodeReference nr)
                                                    throws CommunicationException {
        return sendMessage(m, nr, 0);
    }
    
    public final OutputStream sendMessage(Message m, Peer p, long timeout) 
                                                    throws CommunicationException {
        return makeConnection(p, timeout).sendMessage(m);
    }
    
    public final OutputStream sendMessage(Message m, Peer p)
                                                    throws CommunicationException {
        return sendMessage(m, p, 0);
    }
    
    public static int perturbHTL(int htl) {
	float f = randSource.nextFloat();
	if(htl>3 && (htl/maxHopsToLive) > f) {
	    f = randSource.nextFloat();
	    if(f < (1/5)) htl+=2;
	    else if(f < (2/5)) htl+=1;
	    else if(f < (3/5)) htl+=0;
	    else if(f < (4/5)) htl-=1;
	    else htl-=2;
	}
	if(htl > maxHopsToLive) htl = maxHopsToLive;
	return htl;
    }
    
    public boolean shouldCache(freenet.message.StoreData sd) {
	if(logger == null) throw new NullPointerException();
	if(sd == null) {
	    logger.log(this, "shouldCache returning true because sd == null", 
		       Logger.DEBUG);
	    return true;
	}
	logger.log(this, "shouldCache("+(sd==null?"(null)":sd.toString())
		   +")", Logger.DEBUG);
	// FIXME: use Main.storeSize()?
	long used = storeSize - dir.available();
	long target = (long)(storeSize * (double)minStoreFullPCache);
	if(used < target) {
	    logger.log(this, "shouldCache returning true because "+
		       "used space ("+used+") < target ("+target+") "+
		       "out of maximum "+storeSize, Logger.DEBUG);
	    return true;
	}
	if(sd.shouldCache(randSource, cacheProbPerHop)) {
	    logger.log(this, "shouldCache returning true because "+
		       "sd.shouldCache says so for "+sd, Logger.DEBUG);
	    return true;
	} else {
	    logger.log(this, "shouldCache returning false because "+
		       "sd.shouldCache says so for "+sd, Logger.DEBUG);
	    return false;
	}
    }
    
    public boolean shouldReference(NodeReference nr, freenet.message.StoreData sd) {
	if(nr == null) {
	    logger.log(this, "shouldReference returning false because "+
		       "null ref", Logger.DEBUG);
	    return false;
	}
	int x = rt.getKeyCount();
	logger.log(this, Integer.toString(x)+ " elements in RoutingTable", 
		   Logger.DEBUG);
	if(x < (rtMaxRefs * rtMaxNodes * (double)minRTFullPRef)) {
	    logger.log(this, "shouldReference because RT less than required size",
		       Logger.DEBUG);
	    return true;
	} else {
	    if(sd == null) {
		logger.log(this, "shouldReference because null StoreData",
			   Logger.DEBUG);
		return true;
	    } else {
		if(sd.shouldCache(randSource, cacheProbPerHop)) {
		    logger.log(this, "shouldReference returning true because "+
			       "sd.shouldCache says so for "+sd, Logger.DEBUG);
		    return true;
		} else {
		    logger.log(this, "shouldReference returning false because "+
			       "sd.shouldCache says so for "+sd, Logger.DEBUG);
		    return false;
		}
	    }
	}
    }
}







